<?php

namespace App\Http\Controllers\Api\School;

use App\Http\Controllers\Controller;
use App\Http\Resources\School\SchoolEmployeeResource;
use JWTAuth;
use App\Helpers\Helper;

use Illuminate\Http\Request;
use App\Http\Requests\School\SchoolEmployeeRequest;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;

class TeacherController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api',,'permission:teachers']);
    }


    /** function store school teacher informations */
    public function store(SchoolEmployeeRequest $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $data = $request->all();
        $data['school_id'] = $school->id;
        $data['current_school_year'] = Helper::getSchoolYear();
        $data['type'] = 'teacher';
        $teacher=SchoolEmployee::create($data);

        /** create users accounts */
        $temp_password =  'teacher'.mt_rand(100000, 999999);
        $this->createUserAccounts($teacher->id,$teacher->name,$teacher->email,$teacher->phone,$temp_password);

        $teacher = new SchoolEmployeeResource($teacher); 
        return response()->json(['teacher'=>$teacher,'message'=>trans('api.record stored successfully')]);
    }

    /** function show school teacher informations */
    public function show(Request $request){
        $teacher= SchoolEmployee::findOrFail($request->teacher_id);
        $teacher = new SchoolEmployeeResource($teacher);        
        return response()->json(['teacher'=>$teacher,'message'=>trans('api.record details')]);
    }

    /** function update school teacher informations */
    public function update(SchoolEmployeeRequest $request,$id){
        $teacher= SchoolEmployee::findOrFail($id);
        $teacher->update($request->all());   
        $teacher = new SchoolEmployeeResource($teacher);      
        return response()->json(['teacher'=>$teacher,'message'=>trans('api.record updated successfully')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(Request $request){
        
        // Start a database transaction
        DB::beginTransaction();
        try {
            $employee = SchoolEmployee::find($request->teacher_id);
            // Delete related user
            User::where('id', $employee->user_id)->forceDelete();
            // Delete school employees
            $employee->forceDelete();
            // Commit the transaction
            DB::commit();
        } catch (\Exception $e) {
            // Rollback the transaction if something goes wrong
            DB::rollBack();
            // Log the exception or handle the error as needed
            Log::error('Error deleting records: ' . $e->getMessage());
        }
        return response()->json(['message'=>trans('api.record deleted successflly')]);
    }

    /** function create user account for adminstrative */
    public function createUserAccounts($empId,$name,$email,$phone,$temp_password){
        $user = new User();
        $user->name = $name ;
        $user->email = $email ;
        $user->phone = $phone ;
        $user->password = Hash::make($temp_password) ;
        // $user->remember_token = $request->remember_token ;
        $user->status = 'active' ;
        $user->user_type = 'teacher' ;
        $user->verification_code = mt_rand(100000, 999999);
        $user->save();

        /** add user Id to school employee */
        $schoolEmployee = SchoolEmployee::find($empId);
        $schoolEmployee->user_id = $user->id;
        $schoolEmployee->save();
    }

}
