<?php

namespace App\Http\Controllers\Api\School;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\School\SchoolClassResource;
use App\Http\Resources\School\ClassNameResource;
use App\Http\Resources\School\SchoolClassNameResource;
use App\Http\Resources\School\CurrentWorkResource;
use App\Http\Resources\School\SchoolFacilitieResource;
use App\Http\Resources\School\SchoolReferenceResource;
use App\Http\Resources\School\SchoolResource;
use App\Http\Resources\School\SpecializationResource;
use App\Http\Resources\School\SchoolStudentResource;
use App\Http\Resources\School\SchoolEmployeeResource;
use JWTAuth;

use Illuminate\Http\Request;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolReference;
use App\Models\AdminDashboard\School\SchoolFacilitie;
use App\Models\AdminDashboard\School\Student;

use App\Imports\StudentsImport;
use App\Imports\TeachersImport;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\CurrentWork;
use App\Models\AdminDashboard\School\Specialization;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;


class SchoolController extends Controller
{
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api',,'permission:schools']);
    }


    /** function return school Students  */
    public function getSchools(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        // Start with the base query
        $data = School::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\School', $queryParams);
        }
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolResource::collection($data->paginate($perPage));

        return response()->json(['schools'=>$filterData,'message'=>trans('api.all school records')]);
    }

    /** function return school informations */
    public function getSchoolInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $school= new SchoolResource($school);
        return response()->json(['school'=>$school,'message'=>trans('api.school informations')]);
    }

    /** function return school Facilities */
    public function getSchoolFacilitiesInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolFacilities = SchoolFacilitie::where('school_id',$request->school_id)->firstOrFail();
        $schoolFacilities= new SchoolFacilitieResource($schoolFacilities);
        return response()->json(['schoolFacilities'=>$schoolFacilities,'message'=>trans('api.school facilities informations')]);
    }

    /** function return school References */
    public function getSchoolReferencesInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolReferences = SchoolReference::where('school_id',$request->school_id)->firstOrFail();
        $schoolReferences= new SchoolReferenceResource($schoolReferences);
        return response()->json(['schoolReferences'=>$schoolReferences,'message'=>trans('api.school references informations')]);
    }

    /** function return school Students  */
    public function getSchoolStudentsInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        // Start with the base query
        $data = Student::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key,['per_page','class_name_id']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\Student', $filterData);
        }
        $data->where('school_id',$school->id);

        // custom filter////
        if($request->class_name_id){
            $schoolClasseIds = SchoolClass::where('class_name_id',$request->class_name_id)->pluck('id')->toArray();
            $data->whereIn('class_id',$schoolClasseIds);
        }

        if($request->class_id){
            $schoolClasseIds = SchoolClass::where('class_name_id',$request->class_name_id)->pluck('id')->toArray();
            $data->where('class_id',$request->class_id);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolStudentResource::collection($data->paginate($perPage));

        return response()->json(['schoolStudents'=>$filterData,'message'=>trans('api.school Students records')]);
    }

    /** function return school Teachers  */
    public function getSchoolTeachrsInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        // Start with the base query
        $data = SchoolEmployee::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\SchoolEmployee', $queryParams);
        }

        $data->where('school_id',$school ->id)->where('type','teacher');
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolEmployeeResource::collection($data->paginate($perPage));

        return response()->json(['schoolTeachers'=>$filterData,'message'=>trans('api.school teachers records')]);
    }

    /** function return school Adminstratives  */
    public function getSchoolAdminstrativesInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        // Start with the base query
        $data = SchoolEmployee::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\SchoolEmployee', $queryParams);
        }

        $data->where('type','adminstrative')->where('school_id',$school->id);
        
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolEmployeeResource::collection($data->paginate($perPage));

        return response()->json(['schoolAdminstratives'=>$filterData,'message'=>trans('api.school adminstratives records')]);
    }


    /** function update school informations */
    public function updateSchoolInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $school->update($request->except('school_id'));
        return response()->json(['message'=>trans('api.data updated successfully')]);
    }

    /** function update school Facilities */
    public function updateSchoolFacilitiesInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolFacilitie = SchoolFacilitie::where('school_id',$school->id)->firstOrFail();
        $schoolFacilitie->update($request->all());
        return response()->json(['message'=>trans('api.data updated successfully')]);
   }

    /** function update school References */
    public function updateSchoolReferencesInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolReference = SchoolReference::where('school_id',$school->id)->firstOrFail();
        $schoolReference->update($request->all());
        return response()->json(['message'=>trans('api.data updated successfully')]);
    }

    /** function update school Students  */
    public function updateSchoolStudentsInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        
        /** delete school old records before upload new file */
        SchoolClass::where('school_id',$school->id)->delete();
        Student::where('school_id',$school->id)->forceDelete();
        
        $file= $request->file('file');
        $skipRows = [0,2,4,6,5,8,9,10,12,13,14,15,16,17,18]; // Define the rows to skip
        Excel::import(new StudentsImport($file,$skipRows,$request->school_id), $file);
        return response()->json(['message'=>trans('api.studetn records updated successfully')]);
    }

    /** function update school Teachers  */
    public function updateSchoolTeachrsInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }

        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        /** delete school old records before upload new file */
        SchoolEmployee::where('school_id',$school->id)->forceDelete();

        $file= $request->file('file');
        $skipRows = [0,1,2,3,4,5,6,7,8,9,10,11,12,13]; // Define the rows to skip
        Excel::import(new TeachersImport($file,$skipRows,$request->school_id), $file);
        return response()->json(['message'=>trans('api.teachers records updated successfully')]);
    }

    /** function update school Adminstratives  */
    public function updateSchoolAdminstrativesInfo(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        
        return response()->json(['message'=>trans('api.data updated successfully')]);
    }

    /** function return current work */
    public function getCurrentWorks(){
        $currentWorks = CurrentWorkResource::collection(CurrentWork::get());
        return response()->json(['currentWorks'=>$currentWorks,'message'=>trans('api.current work job titles')]);
    }

    /** function return specializations */
    public function getSpecializations(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }

        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $specializations = SpecializationResource::collection(Specialization::get());
        return response()->json(['specializations'=>$specializations,'message'=>trans('api.school grade specilizations')]);
    }


    /** function return school classes names */
    public function getClassNames(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $classNames = ClassNameResource::collection(ClassName::where('school_grade_id',$school->school_grade_id)->get());
        return response()->json(['classNames'=>$classNames,'message'=>trans('api.class names')]);
    }


    /** function return school classes categories */
    public function getClassCategories(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
       
        $classCategories = ClassName::where('school_grade_id',$school->school_grade_id)->where('name','like',"%$request->class_name%")->select('category')
        ->distinct()
        ->get();       
       
        return response()->json(['classCategories'=>$classCategories,'message'=>trans('api.class categories')]);
    }

    /** function return school classes */
    public function getSchoolClasses(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        
        $classes = SchoolClassResource::collection(SchoolClass::where('school_id',$school->id)->get());
        return response()->json(['classes'=>$classes,'message'=>trans('api.school classes')]);
    }

    /** function return school intsab classes  */
    public function setEntsabSchoolClass(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        /**set entsab classes*/
        $classNameIds = $request->classNameIds;
        foreach($classNameIds as $classNameId){
            $class = SchoolClass::where('school_id',$request->school_id)->where('class_name_id',$classNameId)->first();
            $class->entsab ='yes';
            $class->save();
        }
        return response()->json(['message'=>trans('api.school entsab classes is setted')]);
    }

     /** function return school intsab classes */
     public function getEntsabClasses(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $entsabClasses = SchoolClassResource::collection(SchoolClass::where('school_id',$school->id)->where('entsab','yes')->get());
        
        return response()->json(['entsabClasses'=>$entsabClasses,'message'=>trans('api.entsab classes')]);
    }

    /** function return school intsab classes students */
    public function getEntsabClassStudents(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $entsabClassIds = SchoolClass::where('school_id',$school->id)->where('entsab','yes')->pluck('id')->toArray();
    
        // Start with the base query
        $data = Student::where('school_id',$school->id)->whereIn('class_id',$entsabClassIds);
        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\Student', $queryParams);
        }
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolStudentResource::collection($data->paginate($perPage));

        return response()->json(['filterData'=>$filterData,'message'=>trans('api.entsab classes students')]);
    }

    /** functio retrn all schols in the system */
    public function getALlSchools(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }

        $schools = SchoolResource::collection(School::get());
        return response()->json(['schools'=>$schools,'message'=>trans('api.all registred schools in system')]);
    }

    /** function return all employees in the school */
    public function getAllSchoolEmployees(Request $request){
        
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        // Start with the base query
        $data = SchoolEmployee::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\AdminDashboard\School\SchoolEmployee', $queryParams);
        }

        $data->where('school_id',$school->id)->orderByRaw("FIELD(type, 'adminstrative', 'teacher') ASC");
        
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolEmployeeResource::collection($data->paginate($perPage));

        return response()->json(['schoolEmployees'=>$filterData,'message'=>trans('api.all school employees')]);
    }

    /** delete school and its related */
    public function deleteSchool(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $school->delete();
        return response()->json(['message'=>trans('api.record deleted successflly')]);
    }

    public function get_schoolClass_students($school_class_id){
        $students  = Student::where('class_id', $school_class_id)->select('id','name')->get();
        return response()->json([
            'students' => $students
        ]);
    }


}
