<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Tables\ShiftSchedules;

use App\Http\Controllers\Controller;
use App\Http\Resources\ManagerDashboard\Tables\ShiftSchedule\SemesterShiftResource;
use App\Http\Resources\ManagerDashboard\Tables\ShiftSchedule\ShiftScheduleResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftTeacher;
use Illuminate\Http\Request;
use JWTAuth;
use Illuminate\Support\Facades\Validator; 


class ShiftScheduleController extends Controller
{

    public function __construct()
    {
        //$this->middleware(['auth:api','permission:shift-schedules']);
    }

    /**
     * Display a listing of the resource.
     */ 
    public function getAll(){
        $semesterShiftSchedules = SemesterShiftResource::collection(SchoolSemester::all());
        return response()->json(['semesterShiftSchedules'=>$semesterShiftSchedules,'message' => trans('api.list off all records')]);
    }

    /**
     * Display the specified resource.
     */
    public function getById(Request $request)
    {
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School:: where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();

        $shiftSchedule = ShiftSchedule::findOrFail($request->shift_schedule_id);
        $shiftSchedule = new ShiftScheduleResource($shiftSchedule);

        $ShiftScheduleTeachers = ShiftTeacher::where('school_id',$school->id)->where('shift_schedule_id',$shiftSchedule->id)->get();

        if(count($ShiftScheduleTeachers) >0){
            return response()->json(['shiftSchedule' => $shiftSchedule,'created_status'=>'yes','message' => trans('api.shift schedule')]);
        }
        return response()->json(['shiftSchedule' => $shiftSchedule,'created_status'=>'no','message' => trans('api.shift schedule')]);
    }

    /**
     * function store shift schduke informations
    */
    public function store(Request $request)
    {
        $token = $request->bearerToken();
        if ($token) {
            $user = JWTAuth::toUser($token);
        }
    
        // Validate that the school exists for this user
        $school = School::where('user_id', $user->id)
                        ->where('id', $request->school_id)
                        ->firstOrFail();
    
        // Validate input data
        $validator = Validator::make($request->all(), [
            'teacher_id' => 'required',
            'shift_schedule_id' => 'required|exists:shift_schedules,id',
            'shift_schedule_day_id' => 'required',
        ]);
    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }
    
        // Convert teacher_id and shift_schedule_day_id to arrays
        $teacherIds = explode(",", $request->teacher_id);
        $shiftScheduleDayIds = explode(",", $request->shift_schedule_day_id);
    
        // Validate each teacher ID to ensure it belongs to the school
        foreach ($teacherIds as $teacherId) {
            $teacherExists = SchoolEmployee::where('id', $teacherId)
                                           ->where('school_id', $school->id)
                                           ->exists();
    
            if (!$teacherExists) {
                return response()->json(['error' => 'Teacher ID ' . $teacherId . ' is invalid for this school.'], 422);
            }
        }
    
        // Proceed with storing shift schedule data
        $shiftSchedule = ShiftSchedule::findOrFail($request->shift_schedule_id);
    
        foreach ($teacherIds as $key => $teacherId) {
            if (isset($shiftScheduleDayIds[$key])) { 
                /** check if day added before */
                $check = ShiftTeacher::where('school_id',$school->id)->where('shift_schedule_id',$shiftSchedule->id)->where('shift_schedule_day_id',$shiftScheduleDayIds[$key])->first();
                if($check){
                    $check->update([
                        'school_employee_id' => $teacherId
                    ]);
                }else{
                    ShiftTeacher::create([
                        'shift_schedule_id' => $shiftSchedule->id,
                        'school_id' => $school->id,
                        'shift_schedule_day_id' => $shiftScheduleDayIds[$key],
                        'school_employee_id' => $teacherId,
                    ]);
                }
                
            }
        }
    
        return response()->json(['message' => trans('api.shift schedule created successfully')]);
    }
    


}