<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Tables\ClassRoomVisits;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Tables\ClassRoomVisits\StoreClassRoomVisitRequest;
use App\Http\Requests\ManagerDashboard\Tables\ClassRoomVisits\UpdateClassVisitRequest;
use App\Http\Resources\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisitCollection;
use App\Http\Resources\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisitResource;
use App\Models\AdminDashboard\School\Period;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\Subject;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisit;
use App\Models\ManagerDashboard\Tables\Teacher;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;
use JWTAuth;

class ClassRoomVisitController extends Controller
{
    use LogsActivity;
    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request,School $school)
    {
       $classRoomVisites = new ClassroomVisitCollection(ClassroomVisit::where('school_id',$school->id)->paginate($request->per_page));
       return response()->json($classRoomVisites,200);
    }

     /**
     * Create a newly created resource in storage.
     */
    public function create()
    {
        $teachers = Teacher::select('id','name')->get();
        $periods  = Period::select('id','name')->get();
        $subjects = Subject::select('id','name')->get();
        $classes  = SchoolClass::select('id','class_name')->get(); 
        return response()->json(['teachers'=>$teachers,'periods'=>$periods,'subjects'=> $subjects,'classes'=>$classes ],200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreClassRoomVisitRequest $request)
    {

        $data = $request->validated();

        $schoolId = $data ['school_id']; 
        
        foreach ($data['data'] as $semesterVisit) {
            foreach ($semesterVisit['visites'] as $visit) {
                $classRoomVisit = new ClassroomVisit();
    
                $classRoomVisit->school_id =   $schoolId ;
                $classRoomVisit->semester_id = $semesterVisit['semester_id'];
                $classRoomVisit->visiting_teacher_id = $visit['visiting_teacher_id'];
                $classRoomVisit->visited_teacher_id = $visit['visited_teacher_id'];
                $classRoomVisit->period_id = $visit['period_id'];
                $classRoomVisit->subject_id = $visit['subject_id'];
                $classRoomVisit->school_class_id = $visit['school_class_id'];
                $classRoomVisit->date_type = $visit['date_type'];
                $classRoomVisit->date = \Carbon\Carbon::createFromFormat('d/m/Y', $visit['date'])->format('Y-m-d');
                $classRoomVisit->save();
            }
        }
        // ------------------------------- School ID -----------------------
      
        $this->ManagerlogActivity('ClassroomVisit', 'store', $schoolId, '/tables/classRoomVisites/getAll');
        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }
    // /**
    //  * Display the specified resource.
    //  */
    public function getSemesterVisits(School $school,SchoolSemester $semester)
    {
      
       $semesterVisites = ClassroomVisitResource::collection( ClassroomVisit::where('school_id',$school->id)->where('semester_id',$semester->id)->get());
       return response()->json(['semesterVisites' => $semesterVisites],200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateClassVisitRequest $request)
    {

        $data = $request->validated();

        $schoolId = $data ['school_id']; 

        foreach ($data['data'] as $semesterVisit) {
            // First, delete existing visits for the given semester_id
            ClassroomVisit::where('school_id',$schoolId)->where('semester_id', $semesterVisit['semester_id'])->delete();
    
            // Then, create new visits
            foreach ($semesterVisit['visites'] as $visit) {
                $classRoomVisit = new ClassroomVisit();

                $classRoomVisit->school_id =   $schoolId ;
                $classRoomVisit->semester_id = $semesterVisit['semester_id'];
                $classRoomVisit->visiting_teacher_id = $visit['visiting_teacher_id'];
                $classRoomVisit->visited_teacher_id = $visit['visited_teacher_id'];
                $classRoomVisit->period_id = $visit['period_id'];
                $classRoomVisit->subject_id = $visit['subject_id'];
                $classRoomVisit->school_class_id = $visit['school_class_id'];
                $classRoomVisit->date_type = $visit['date_type'];
                $classRoomVisit->date = \Carbon\Carbon::createFromFormat('d/m/Y', $visit['date'])->format('Y-m-d');
                $classRoomVisit->save();
            }
        }
        // ------------------------------- School ID -----------------------
        $school_id = 1; //$classRoomVisit->class->school_id;
        $this->ManagerlogActivity('ClassroomVisit', 'store', $school_id, '/tables/classRoomVisites/getAll');
        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ClassroomVisit $classRoomVisit)
    {
        $school_id = 1; //$classRoomVisit->class->school_id;
        $classRoomVisit->delete();
        $this->ManagerlogActivity('ClassroomVisit', 'delete', $school_id,);
        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }
}
