<?php

namespace App\Http\Controllers\Api\ManagerDashboard;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\ManagerDashboard\Proceed\ProceedStoreRequest;
use App\Http\Requests\ManagerDashboard\Proceed\ProceedUpdateRequest;
use App\Models\ManagerDashboard\Proceed;
use App\Http\Resources\ManagerDashboard\Proceed\ProceedResource;
use App\Models\ManagerDashboard\ProceedUser;
use App\Traits\LogsActivity;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\DB;


class ProceedController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:proceeds']);
    }

    /*
        -this method will return all Model recoreds
    */
     public function getAll(Request $request)
    {
        $data = Proceed::where('proceed_type', $request->proceed_type_value);
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'date';
        }, ARRAY_FILTER_USE_KEY);

        $perPage = $queryParams['per_page'] ?? 15;

        $proceeds = ProceedResource::collection($data->paginate($perPage));
        return response()->json([
            'proceeds' => $proceeds,
            'message' => trans('api.list of all available records'),
        ]);
    }
    // public function getAll(Request $request)
    // {
    //     $data = Proceed::where('proceed_type',$request->proceed_type_value);
    //     $queryParams = $request->query();
    //     $filterData = array_filter($queryParams, function ($key) {
    //         return $key !== 'date';
    //     }, ARRAY_FILTER_USE_KEY);
    //     // Apply filters if any
    //     if (!empty($filterData)) {
    //         $data = Helper::filterData('App\Models\ManagerDashboard\Proceed', $filterData);
    //     }
    //     $perPage = $queryParams['per_page'] ?? 15;

    //     $proceeds = ProceedResource::collection($data->paginate($perPage));
    //     $groupedData = $proceeds->getCollection()->groupBy('proceed_type')->map(function ($items, $key) use($perPage) {
    //         $page = LengthAwarePaginator::resolveCurrentPage();
    //         $paginatedItems = new LengthAwarePaginator(
    //             $items->forPage($page, $perPage),
    //             $items->count(),
    //             $perPage,
    //             $page
    //         );
    //         $paginatedItems->setPath(request()->url())->appends(request()->query());
    //         return [
    //             'proceed_type_value' => $key, // The English name of proceed_type
    //             'proceed_type_name' => __('api.'.'proceed_' . $key), // The Arabic name (translated)
    //             'data' => $paginatedItems, // The actual data for this type
    //         ];
    //     })->values();
    //     return response()->json([
    //         'proceeds' => $groupedData,
    //         'message' => trans('api.list of all available records'),
    //     ]);
    // }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById($id)
    {
        $proceed = Proceed::findOrFail($id);
        $proceed = new ProceedResource($proceed);
        return response()->json(['proceed' => $proceed, 'message' => trans('api.proceed details')]);
    }

    /* this method will stord data to DB Model*/
    public function store(ProceedStoreRequest $request)
    {
        $request->validated();
        DB::beginTransaction();
        $data = $request->except('employes_ids');
        if ($data['date_type'] === 'hijri') {
            $data['date'] = Helper::getCoptic($data['date']);
            $data['date_type'] = 'coptic';
        }

        $proceed = Proceed::create($data);
        if ($request->proceed_type == 'general' || $request->proceed_type == 'incident') {
            foreach ($request->employes_ids as $employee_id) {
                $proceed->proceedUsers()->create([
                    'employee_id' => $employee_id
                ]);
            }
        }
        // Log the activity for the created event
        $this->ManagerlogActivity('Proceed', 'store', $request->school_id, '/officialLetters/proceeds/' . $proceed->id);

        DB::commit();
        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(ProceedUpdateRequest $request, $id)
    {

        $proceed = Proceed::findOrFail($id);
        $request->validated();
        DB::beginTransaction();
        $data = $request->except('teacher_ids');
        if ($request->date_type) {
            if ($data['date_type'] === 'hijri') {
                $data['date'] = Helper::getCoptic($data['date']);
                $data['date_type'] = 'coptic';
            }
        }
        $proceed->update($data);
        if (($proceed->proceed_type == 'general' || $proceed->proceed_type == 'incident')
            && $request->employes_ids
        ) {
            $proceed->proceedUsers()->delete();
            foreach ($request->employes_ids as $employee_id) {
                $proceed->proceedUsers()->create([
                    'employee_id' => $employee_id
                ]);
            }
        }
        DB::commit();

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id)
    {
        Proceed::findOrFail($id)->forceDelete();
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id)
    {
        Proceed::findOrFail($id)->delete();
        return response()->json(['message' => trans('api.record archived successflly')]);
    }
    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id)
    {
        Proceed::withTrashed()->findOrFail($id)->restore();
        return response()->json(['message' => trans('api.record restored successflly')]);
    }
}
