<?php

namespace App\Http\Controllers\Api\ManagerDashboard\LetterAndAlart;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\LettersAndAlarts\StoreAlertRequest;
use App\Http\Requests\ManagerDashboard\LettersAndAlarts\UpdateAlertRequest;

use App\Http\Resources\ManagerDashboard\LetterAndAlart\AlertResource;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\OfficialSpeeches\AlertNote;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;

class AlertController extends Controller
{
    use LogsActivity;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:Alert']);
    }
    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
        $data = Alert::query()->with('notes');
     
        // Retrieve all query parameters
        $queryParams = $request->query();

        $filterData = array_filter($queryParams, function ($key) {
           return $key !== 'per_page';
       }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
           $data = Helper::filterData('App\Models\ManagerDashboard\OfficialSpeeches\Alert', $filterData);
       }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
   
        $filterData = AlertResource::collection($data->paginate($perPage));


        return response()->json([
            'alerts' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);

       
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAlertRequest $request)
    {
        $validatedData = $request->validated();

        $notes = $validatedData['notes'];

        unset($validatedData['notes']);

        $alert = Alert::create($validatedData);

        foreach ($notes as $note) {
            $alertNote = new AlertNote();
            $alertNote->content = $note;
            $alert->notes()->save($alertNote);
        }
        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    /**
     * Display the specified resource.
     */
    public function getById(Alert $alert)
    {
        $alert = new AlertResource($alert->load('notes'));
        return  response()->json(['alert' => $alert], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAlertRequest $request, Alert $alert)
    {
        $validatedData = $request->validated();

        if (isset($validatedData['notes'])) {
            $notes = $validatedData['notes'];
            unset($validatedData['notes']);

            $alert->update($validatedData);

            $alert->notes()->forceDelete();

            foreach ($notes as $note) {
                $alertNote = new AlertNote();
                $alertNote->content = $note;
                $alert->notes()->save($alertNote);
            }
        } else {
            $alert->update($validatedData);
        }
        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }

    /**
     * soft Delete the specified resource from storage.
     */
    public function archive(Alert $alert)
    {

        $alert->delete();

        $alert->notes()->delete();

        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Alert $alert)
    {
        $alert->forceDelete();
        $alert->notes()->forceDelete();
        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }

    /**
     * restore the specified resource from storage.
     */
    public function restore(Alert $alert)
    {
        $alert->restore();
        $alert->notes()->restore();
        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }
}
