<?php

namespace App\Http\Controllers\Api\ManagerDashboard\ClassRoomVisit;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\ClassRoomVisit\StoreVisitRateRequest;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitCard;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassRoomVisitSession;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitNeed;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRate;
use App\Models\ManagerDashboard\ClassRoomVisits\ClassVisitRecommendation;
use Illuminate\Http\Request;

class ClassVisitRateController extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(ClassRoomVisitSession $classRoomVisit,StoreVisitRateRequest $request)
    {
    
        $validated = $request->validated();
     
         // Convert visit_method_ids array into a comma-separated string
    $validated['data']['class_visit_card']['visit_method_ids'] = implode(',', $validated['data']['class_visit_card']['visit_method_ids']);

       

      // Store class visit rate
      ClassVisitCard::updateOrCreate(
            ['classVisit_id' =>  $classRoomVisit->id],
            $validated['data']['class_visit_card']
        );

           // Store class visit rate

           if (isset($validated['data']['class_visit_rate']['school_class_id'])){
              
                $classRoomVisit->update([ 'school_class_id' => $validated['data']['class_visit_rate']['school_class_id']]);
           }
           if (isset($validated['data']['class_visit_rate']['period_id'])){
              
                $classRoomVisit->update([ 'visit_period_id' => $validated['data']['class_visit_rate']['period_id']]);
           }
         
      ClassVisitRate::updateOrCreate(
        ['classVisit_id' =>   $classRoomVisit->id],
        $validated['data']['class_visit_rate']
    );



       // Store class visit recommendation
        ClassVisitRecommendation::updateOrCreate(
            ['classVisit_id' =>   $classRoomVisit->id],
            $validated['data']['class_visit_recommendation']
        );


       // Store class visit needs
       foreach ($validated['data']['class_visit_need'] as $need) {
        ClassVisitNeed::updateOrCreate(
            ['classVisit_id' =>   $classRoomVisit->id, 'need' => $need['need']],
            ['recommended' => $need['recommended']]
        );
    }

    return response()->json(['message' => trans('api.record stored successflly')], 200);
    
    }
}
