<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Circulars;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Circulars\TeacherGeneralCircularRequest;
use App\Http\Resources\ManagerDashboard\Circulars\TeacherGeneralCircularResource;
use App\Models\ManagerDashboard\Circulars\TeacherGeneralCircular;
use App\Models\ManagerDashboard\Circulars\TeacherGeneralCircularTeacher;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;

class TeacherGeneralCircularController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify','permission:internal_circulars']);
    }
    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request){
        // Start with the base query
        $data = TeacherGeneralCircular::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Circulars\TeacherGeneralCircular', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = TeacherGeneralCircularResource::collection($data->paginate($perPage));

        return response()->json([
            'teacher_general_circulars' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById(TeacherGeneralCircular $teacher_general_circular){
        $teacher_general_circular = new TeacherGeneralCircularResource($teacher_general_circular);
        return response()->json(['teacher_general_circular'=>$teacher_general_circular,'message'=>trans('api.general teatcher circulars details')],200);
    }

    /* this method will stord data to DB Model*/
    public function store(TeacherGeneralCircularRequest $request){
        $teacher_general_circular = TeacherGeneralCircular::create([
            'school_id' => $request->school_id,
            'title' => $request->title,
        ]);
        if($request->teachers) {
            foreach ($request->teachers as $teacher) {
                TeacherGeneralCircularTeacher::create([
                    'teacher_general_circular_id' => $teacher_general_circular->id,
                    'school_employee_id' => $teacher,
                ]);
            }
        }
        // ------------------------------- School ID -----------------------
        $school_id = $request->school_id;
        $this->ManagerlogActivity('TeacherGeneralCircular', 'store', $school_id, '/circulars/teacher-general-circulars/' . $teacher_general_circular->id . '/details');

        return response()->json(['message'=>trans('api.record stored successflly')],200);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(TeacherGeneralCircularRequest $request,TeacherGeneralCircular $teacher_general_circular)
    {
        $teacher_general_circular->update([
            'school_id' => $request->school_id,
            'title' => $request->title,
        ]);
        
        TeacherGeneralCircularTeacher::where('teacher_general_circular_id',$teacher_general_circular->id)->forceDelete();
        if($request->teachers) {
            foreach ($request->teachers as $teacher) {
                TeacherGeneralCircularTeacher::create([
                    'teacher_general_circular_id' => $teacher_general_circular->id,
                    'school_employee_id' => $teacher,
                ]);
            }
        }
        // ------------------------------- School ID -----------------------
        $school_id = $teacher_general_circular->school_id;
        $this->ManagerlogActivity('TeacherGeneralCircular', 'update', $school_id, '/circulars/teacher-general-circulars/' . $teacher_general_circular->id . '/details');
        
        return response()->json(['message'=>trans('api.record updated successflly')],200);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive(TeacherGeneralCircular $teacher_general_circular){
        $school_id = $teacher_general_circular->school_id;
        $teacher_general_circular->delete();
        $this->ManagerlogActivity('TeacherGeneralCircular', 'archive', $school_id);

        return response()->json(['message'=>trans('api.record archived successflly')],200);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function destroy(TeacherGeneralCircular $teacher_general_circular){
        $school_id = $teacher_general_circular->school_id;
        $teacher_general_circular->forceDelete();
        $this->ManagerlogActivity('TeacherGeneralCircular', 'delete', $school_id);

        return response()->json(['message'=>trans('api.record deleted successflly')],200);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore(TeacherGeneralCircular $teacher_general_circular){
        $school_id = $teacher_general_circular->school_id;
        $teacher_general_circular->restore();
        $this->ManagerlogActivity('TeacherGeneralCircularResource', 'restore', $school_id);
        return response()->json(['message'=>trans('api.record restored successflly')],200);
    }
}