<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Assignments;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Assignments\AssignmentTeamRequest;
use App\Models\ManagerDashboard\Assignments\AssignmentTeam;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Meeting;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\TeamMember;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AssignmentTeamController extends Controller
{
   

    /**
     * Store a newly created resource in storage.
     */
    public function store(Team $team, AssignmentTeamRequest $request)
    {


        $data = $request->validated();
        $teamId = $team->id;

        // Store Assignment 
        $assignmentTeam = AssignmentTeam::updateOrCreate(
            ['team_id' => $teamId],
            $data['assignment']
        );

        // Store Team Members

        foreach ($data['team_members'] as $team_member) {
            TeamMember::updateOrCreate(
                [
                    'team_id' => $teamId,
                    'assignment_team_id' => $assignmentTeam->id,
                    'employee_id' => $team_member['employee_id'],
                    'assignment_work' => $team_member['assiment_work']
                ],

            );
        }

        // Store Commitee Meetings

        foreach ($data['team_semesters_meetings'] as $team_semester_meetings) {
            $semesterId = $team_semester_meetings['semester_id'];

            foreach ($team_semester_meetings['meetings'] as $team_semester_meeting) {

                // Store the meeting
                Meeting::updateOrCreate(
                    [
                        'school_id' => $team->school->id,
                        'semester_id' => $semesterId,
                        'name' => $team_semester_meeting['name'],
                        'date' => $team_semester_meeting['date'],
                        'date_type' => $team_semester_meeting['date_type'],
                        'place' => $team_semester_meeting['place'] ?? null,
                        'model_type' => 'teams',
                        'model_id' => $teamId,
                        'meeting_type' => 'periodic',
                        'meeting_status' => 'not_completed',
                    ]
                );
            }
        }

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }



    /**
     * Soft Delete.
     */
    public function archive(Team $team, $assignmentid)
    {

        DB::beginTransaction();

        try {
            // Delete the assignment team
            AssignmentTeam::where('team_id', $team->id)->delete();

            // Delete the team members
            TeamMember::where('team_id', $team->id)
                ->where('assignment_team_id', $assignmentid)
                ->delete();

            // Delete the related meetings
            Meeting::where('model_type', 'teams')
                ->where('model_id', $team->id)
                ->delete();

            // Commit the transaction if everything is successful
            DB::commit();

            return response()->json(['message' => trans('api.record archived successfully')]);
        } catch (\Exception $e) {
            // Rollback the transaction if any error occurs
            DB::rollBack();

            return response()->json(['error' => trans('api.failed_to_archive_record')], 500);
        }

        return response()->json(['message' => trans('api.record archived successflly')]);
    }



    /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(Team $team, $assignmentid)
    {
        AssignmentTeam::where('team_id', $team->id)
            ->restore();

        Meeting::where('model_type', 'teams')
            ->where('model_id', $team->id)
            ->restore();

        TeamMember::where('team_id', $team->id)
            ->where('assignment_team_id', $assignmentid)
            ->restore();

        return response()->json(['message' => trans('api.record restored successflly')]);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Team $team, $assignmentid)
    {
        AssignmentTeam::where('team_id', $team->id)->forceDelete();
        TeamMember::where('team_id', $team->id)->where('assignment_team_id', $assignmentid)->forceDelete();
        Meeting::where('model_type', 'teams')
            ->where('model_id', $team->id)
            ->forceDelete();

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
