<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Assignments;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Assignments\StoreAssignmentRequest;
use Illuminate\Http\Request;
use App\Models\ManagerDashboard\Assignments\AssignmentCategory;
use App\Http\Resources\ManagerDashboard\Assignments\AssignmentCategoryResource;
use App\Http\Resources\ManagerDashboard\Assignments\CommitteeAssignmentResource;
use App\Http\Resources\ManagerDashboard\Assignments\GeneralAssignmentResource;
use App\Http\Resources\ManagerDashboard\Assignments\TeamAssignmentResource;
use App\Models\ManagerDashboard\Assignments\Assignment;
use App\Models\ManagerDashboard\Assignments\AssignmentEmployee;
use App\Models\ManagerDashboard\Assignments\GeneralAssignment;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use App\Models\AdminDashboard\School\School;
use App\Traits\LogsActivity;

class AssignmentController extends Controller
{
    use LogsActivity;
    /**
     * Display a listing of the resource.
     */
    public function getCategories(School $school,Request $request)
    {
      
        $data = AssignmentCategory::with(['jobs.assignments' => function ($query) use ($school) {
            $query->where('school_id', $school->id);
        }, 'jobs.assignments.assignmentEmployees.employee'])
        ->get();


        $committeesAssignments = CommitteeAssignmentResource::collection(Committee::where('school_id',$school->id)->with('assignment')->get());
        
        $teamsAssignments = TeamAssignmentResource::collection(Team::where('school_id',$school->id)->with('assignment')->get());

        $generalAssignments = GeneralAssignmentResource::collection(GeneralAssignment::where('school_id',$school->id)->with('generalAssignmentEmployees.employee')->get());

        $filterData = AssignmentCategoryResource::collection($data);

        // Inject the committees and teams assignments into the "اللجان و الفرق" category (id: 4)
        $filterData->transform(function ($category) use ($committeesAssignments, $teamsAssignments, $generalAssignments) {
            if ($category->id === 4) {
                $category->committeesAssignments = $committeesAssignments;
                $category->teamsAssignments = $teamsAssignments;
            }

            if ($category->id === 5) {
                $category->generalAssignments = $generalAssignments;
            }
            return $category;
        });

        return response()->json([
            'categories' => $filterData,

            'message' => trans('api.list of all available records'),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAssignmentRequest $request)
    {
        $employeeIds = $request['employees'];  // Extract the names from the request
        // Validate and get the request data, then format the date

        $data = $request->validated();
        $data['date'] = \Carbon\Carbon::createFromFormat('d/m/Y', $data['date'])->format('d/m/Y');
        // Remove 'names' from $data to avoid attempting to insert it into the tklfats table
        unset($data['employees']);

        // Create a new Tklfat record
        $assignment = new Assignment();
        $assignment->fill($data);
        $assignment->save();

        // Store the names for the tklf
        foreach ($employeeIds as $employeeId) {
            $assignmentEmployees = new AssignmentEmployee();
            $assignmentEmployees->assignment_id  = $assignment['id'];
            $assignmentEmployees->employee_id = $employeeId;
            $assignmentEmployees->save();
        }
        // ------------------------------- School ID -----------------------
        $school_id = $request->school_id;
        $this->ManagerlogActivity('Assignment', 'store', $school_id, '/assignments/' . $assignment->id);
        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }
    /**
     * Soft Delete.
     */
    public function archive(Assignment $assignment, $employeeId)
    {
        AssignmentEmployee::where('assignment_id', $assignment->id)->where('employee_id', $employeeId)->delete();

        return response()->json(['message' => trans('api.record archived successflly')]);
    }

        /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(Assignment $assignment, $employeeId)
    {

        AssignmentEmployee::where('assignment_id', $assignment->id)->where('employee_id', $employeeId)->restore();
      
     
        return response()->json(['message' => trans('api.record restored successflly')]);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Assignment $assignment, $employeeId)
    {

        AssignmentEmployee::where('assignment_id', $assignment->id)->where('employee_id', $employeeId)->forceDelete();
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
