<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Assignments;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Assignments\StoreAssignmentCommitteeRequest;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\CommitteeMember;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Meeting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AssignmentCommitteeController extends Controller
{

    /**
     * Store a newly created resource in storage.
     */
    public function store(Committee $committee, StoreAssignmentCommitteeRequest $request)
    {


        $data = $request->validated();
        $committeeId = $committee->id;

        // Store Assignment 
        $assignmentCommittee = AssignmentCommittee::updateOrCreate(
            ['committee_id' => $committeeId],
            $data['assignment']
        );

        // Store Committee Members

        foreach ($data['committee_members'] as $committee_member) {
            CommitteeMember::updateOrCreate(
                [
                    'committee_id' => $committeeId,
                    'assignment_committee_id' => $assignmentCommittee->id,
                    'employee_id' => $committee_member['employee_id'],
                    'assignment_work' => $committee_member['assiment_work']
                ],

            );
        }

        // Store Commitee Meetings

        foreach ($data['committee_semesters_meetings'] as $committee_semester_meetings) {
            $semesterId = $committee_semester_meetings['semester_id'];

            foreach ($committee_semester_meetings['meetings'] as $committee_semester_meeting) {

                // Store the meeting
                Meeting::updateOrCreate(
                    [
                        'school_id' => $committee->school->id,
                        'semester_id' => $semesterId,
                        'name' => $committee_semester_meeting['name'],
                        'date' => $committee_semester_meeting['date'],
                        'date_type' => $committee_semester_meeting['date_type'],
                        'place' => $committee_semester_meeting['place'] ?? null,
                        'model_type' => 'committees',
                        'model_id' => $committeeId,
                        'meeting_type' => 'periodic',
                        'meeting_status' => 'not_completed',
                    ]
                );
            }
        }

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }


    /**
     * Soft Delete.
     */
    public function archive(Committee $committee, $assignmentid)
    {
        DB::beginTransaction();

        try {
            // Delete the assignment committee
            AssignmentCommittee::where('committee_id', $committee->id)->delete();

            // Delete the committee members
            CommitteeMember::where('committee_id', $committee->id)
                ->where('assignment_committee_id', $assignmentid)
                ->delete();

            // Delete the related meetings
            Meeting::where('model_type', 'committees')
                ->where('model_id', $committee->id)
                ->delete();

            // Commit the transaction if everything is successful
            DB::commit();

            return response()->json(['message' => trans('api.record archived successfully')]);
        } catch (\Exception $e) {
            // Rollback the transaction if any error occurs
            DB::rollBack();

            return response()->json(['error' => trans('api.failed_to_archive_record')], 500);
        }

        return response()->json(['message' => trans('api.record archived successflly')]);
    }



    /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(Committee $committee, $assignmentid)
    {
        AssignmentCommittee::where('committee_id', $committee->id)
        ->restore();

        Meeting::where('model_type', 'committees')
        ->where('model_id', $committee->id)
        ->restore();

        CommitteeMember::where('committee_id', $committee->id)
        ->where('assignment_committee_id', $assignmentid)
        ->restore();

        return response()->json(['message' => trans('api.record restored successflly')]);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Committee $committee, $assignmentid)
    {
        AssignmentCommittee::where('committee_id', $committee->id)->forceDelete();
        CommitteeMember::where('committee_id', $committee->id)->where('assignment_committee_id', $assignmentid)->forceDelete();
          // Delete the related meetings
          Meeting::where('model_type', 'committees')
          ->where('model_id', $committee->id)
          ->forceDelete();

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
