<?php
namespace App\Http\Controllers\Api\AdminDashboard\Violation;

use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\DB;

use Illuminate\Http\Request;
use App\Http\Requests\Violation\ViolationTitleStoreRequest;
use App\Http\Requests\Violation\ViolationTitleUpdateRequest;
use App\Models\ViolationTitle;
use App\Models\ViolationType;
use App\Models\ViolationPunishment;
use App\Http\Resources\Violation\ViolationTitleResource;
use App\Traits\LogsActivity;
use Helper;

class ViolationTitleController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:violationTitles']);
    }

    /* this method will stord data to DB Model*/
    public function store(ViolationTitleStoreRequest $request){
        $title = ViolationTitle::create(['name'=>$request->name_id,'violation_grade_id'=>$request->violation_grade_id]);
        foreach($request->violation_type_name as $violation_type_name){
            ViolationType::create(['violation_title_id'=>$title->id, 'name'=>$violation_type_name]);
        }
        foreach($request->punishment_ids as $punishment_id){
            ViolationPunishment::create(['violation_title_id'=>$title->id,'violation_punishment_id'=>$punishment_id]);
        }
        $this->AdminlogActivity('ViolationTitle', 'store', '/violations/grade/' . $request->violation_grade_id);


        return response()->json(['message'=>trans('api.record stored successflly') ]);
    }

    /* this method will update specific Model recored 
        by using ID
    */

    public function update(ViolationTitleUpdateRequest $request, $id)
{
        // Find the violation title or fail
        $title = ViolationTitle::findOrFail($id);

        DB::transaction(function () use ($request, $title) {
            // Update the title name
            $title->update(['name' => $request->name_id]);

            // Update existing violation types
            if (!empty($request->violation_type_name)) {
                foreach ($request->violation_type_name as $type_id => $violation_type_name) {
                    ViolationType::where('id', $type_id)->update(['name' => $violation_type_name]);
                }
            }

            // Create new violation types
            if (!empty($request->new_violation_type_name)) {
                foreach ($request->new_violation_type_name as $new_violation_type_name) {
                    ViolationType::create(['violation_title_id' => $title->id, 'name' => $new_violation_type_name]);
                }
            }

            // Update or create punishment associations
            if (!empty($request->punishment_ids)) {
                ViolationPunishment::where('violation_title_id', $title->id)->delete();
                foreach ($request->punishment_ids as $punishment_id) {
                    ViolationPunishment::updateOrCreate(
                        ['violation_title_id' => $title->id, 'violation_punishment_id' => $punishment_id]
                    );
                }
            }
        });
        $this->AdminlogActivity('ViolationTitle', 'update', '/violations/grade/' . $title->violation_grade_id);
        return response()->json(['message' => trans('api.record updated successflly')]);
}

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id){
        ViolationTitle::findOrFail($id)->forceDelete();
        $this->AdminlogActivity('ViolationTitle', 'delete');

        return response()->json(['message'=>trans('api.record deleted successflly') ]);
    }
    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id)
    {
        ViolationTitle::findOrFail($id)->delete();
        $this->AdminlogActivity('ViolationTitle', 'archive');

        return response()->json(['message' => trans('api.record archived successflly')]);
    }
    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id)
    {
        ViolationTitle::withTrashed()->findOrFail($id)->restore();
        $this->AdminlogActivity('ViolationTitle', 'restore');
        return response()->json(['message' => trans('api.record restored successflly')]);
    }


}