<?php

namespace App\Http\Controllers\Api\AdminDashboard\Procedures;

use App\Http\Controllers\Controller;
use App\Http\Requests\AdminDashboard\Procedures\StoreLateProceduresFormRequest;
use App\Http\Requests\AdminDashboard\Procedures\UpdateLateProceduresFormRequest;
use App\Http\Requests\UpdateStatusRequest;
use App\Http\Resources\AdminDashboard\Procedures\LateProceduresFormResource;
use App\Models\AdminDashboard\Procedures\LateProcedure\LateProceduresForm;
use Illuminate\Http\Request;

class LateProceduresFormController extends Controller
{
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:LateProceduresForm']);
    }
    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
      
            $lateProceduresForms = LateProceduresFormResource::collection(LateProceduresForm::paginate($request->per_page));
            return response()->json(['lateProceduresForms' => $lateProceduresForms, 'message' => trans('api.list of all available records')],200);
      
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreLateProceduresFormRequest $request)
    {
       
            $data = $request->validated();

            LateProceduresForm::create($data);

            return response()->json(['message' => trans('api.record stored successflly')],200);
      
    }

    /**
     * Display the specified resource.
     */
    public function getById(LateProceduresForm $lateProceduresForm)
    {
        
            $lateProceduresForm =  new LateProceduresFormResource($lateProceduresForm);

            return  response()->json(['lateProceduresForm' => $lateProceduresForm],200);
       
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(LateProceduresForm $lateProceduresForm)
    {
       
            $lateProceduresForm = new LateProceduresFormResource($lateProceduresForm);

            return  response()->json(['lateProceduresForm' => $lateProceduresForm], 200);
      
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateLateProceduresFormRequest $request, LateProceduresForm $lateProceduresForm)
    {
       
            $data =  $request->validated();

            $lateProceduresForm->update($data);

            return response()->json(['message' => trans('api.record updated successflly')], 200);
       
    }

       /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(UpdateStatusRequest $request, LateProceduresForm $lateProceduresForm)
    {
     
            $lateProceduresForm->status = $request->status;

            $lateProceduresForm->save();

            return response()->json(['message' => trans('api.record updated successflly')],200);
        
    }

    /**
     * Soft Delete.
     */
    public function archive(LateProceduresForm $lateProceduresForm)
    {
       
            $lateProceduresForm->delete();

            return response()->json(['message' => trans('api.record archived successflly')],200);
        
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(LateProceduresForm $lateProceduresForm)
    {
      
            $lateProceduresForm->forceDelete();

            return response()->json(['message' => trans('api.record deleted successflly')],200);
       
    }

        /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(LateProceduresForm $lateProceduresForm)
    {
       
            $lateProceduresForm->restore();
            
            return response()->json(['message' => trans('api.record restored successflly')],200);
       
    }
}
