<?php

namespace App\Http\Controllers\Api\AdminDashboard\Procedures;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\AdminDashboard\Procedures\StoreLateProcedureRequest;
use App\Http\Requests\AdminDashboard\Procedures\UpdateLateProcedureRequest;
use App\Http\Requests\UpdateStatusRequest;
use App\Http\Resources\AdminDashboard\Procedures\LateProcedureResource;
use App\Models\AdminDashboard\Procedures\LateProcedure\LateProcedure;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;

class LateProcedureController extends Controller
{
    use LogsActivity;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:LateProcedure']);
    }

    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
        // Start with the base query
        $data = LateProcedure::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Filter data is directly from query parameters, excluding `per_page`
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'per_page';
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\AdminDashboard\Procedures\LateProcedure\LateProcedure', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = LateProcedureResource::collection($data->paginate($perPage));


        return response()->json([
            'lateProcedures' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $lateProcedures = LateProcedureResource::collection(LateProcedure::all());

        return response()->json(['lateProcedures' => $lateProcedures], 200);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreLateProcedureRequest $request)
    {

        // Validate the request and retrieve validated data
        $validatedData = $request->validated();

        // Extract Late_form_id from validated data
        $late_form_ids = $validatedData['late_form_id'];
        // Remove Late_form_id from validated data (since it's not a column in LateProcedure)
        unset($validatedData['late_form_id']);

        // Create LateProcedure
        $lateProcedure = LateProcedure::create($validatedData);

        // Attach late_form_ids to the LateProcedure
        $lateProcedure->lateForms()->attach($late_form_ids);
        $this->AdminlogActivity('LateProcedure', 'store', '/procedures/lateProcedures/' . $lateProcedure->id . '/details');

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    /**
     * Display the specified resource.
     */
    public function getById(LateProcedure $lateProcedure)
    {

        $lateProcedure =  new LateProcedureResource($lateProcedure);

        return  response()->json(['lateProcedure' => $lateProcedure], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateLateProcedureRequest $request, LateProcedure $lateProcedure)
    {
        // Update the lateProcedure attributes
        $lateProcedure->update([
            'name_id' => $request['name_id'],
            'late_dayes' => $request['late_dayes'],
            'details' => $request['details'],
            //     'status' => $request['status'],
        ]);

        // Update related lateProceduresForms using sync method
        if (isset($request['late_form_id'])) {
            $late_form_ids = $request['late_form_id'];
            $lateProcedure->lateForms()->sync($late_form_ids);
        }
        $this->AdminlogActivity('LateProcedure', 'update', '/procedures/lateProcedures/' . $lateProcedure->id . '/details');

        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }

    /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(UpdateStatusRequest $request, LateProcedure $lateProcedure)
    {

        $lateProcedure->status = $request->status;
        $lateProcedure->save();
        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }

    /**
     * Soft Delete.
     */
    public function archive(LateProcedure $lateProcedure)
    {

        $lateProcedure->delete();
        $this->AdminlogActivity('LateProcedure', 'archive');
        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }



    /**
     * Remove the specified resource from storage.
     */
    public function destroy(LateProcedure $lateProcedure, Request $requet)
    {


        $lateProcedure->forceDelete();
        // you might want to detach all related forms
        $lateProcedure->lateForms()->detach();
        $this->AdminlogActivity('LateProcedure', 'destroy');

        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }

    /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(LateProcedure $lateProcedure)
    {

        $lateProcedure->restore();
        $this->AdminlogActivity('LateProcedure', 'restore');
        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }
}
