<?php
namespace App\Http\Controllers\Api\AdminDashboard\Page;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\Page\PageStoreRequest;
use App\Http\Requests\Page\PageUpdateRequest;
use App\Models\Page;
use App\Http\Resources\Page\PageResource;
use App\Traits\LogsActivity;

class PageController extends Controller
{
    use LogsActivity;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct(){
        // $this->middleware(['auth:api', 'jwt.verify', 'permission:pages']);
    }

    /*
        -this method will return all Model recoreds
    */
 
    public function getAll(Request $request)
    {
        // Start with the base query
        $data = Page::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Apply filters if any
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\Page', $queryParams);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = PageResource::collection($data->paginate($perPage));

        return response()->json([
            'pages' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored 
        by using ID
    */
    public function getById($id){
        $page = Page::findOrFail($id);
        $page = new PageResource($page);
        return response()->json(['page'=>$page,'message'=>trans('api.page details') ]);
    }

    /* this method will stord data to DB Model*/
    public function store(pageStoreRequest $request){
        $page = Page::create($request->all());
        $this->AdminlogActivity('Page', 'store', '/pages/' . $page->id);

        return response()->json(['message'=>trans('api.record stored successflly') ]);
    }

    /* this method will update specific Model recored 
        by using ID
    */
    public function update(pageUpdateRequest $request,$id){
        Page::findOrFail($id)->update($request->all());
        $this->AdminlogActivity('Page', 'update', '/pages/' . $id);

        return response()->json(['message'=>trans('api.record updated successflly') ]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id){
        Page::findOrFail($id)->delete();
        $this->AdminlogActivity('Page', 'archive');

        return response()->json(['message'=>trans('api.record archived successflly') ]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id){
        Page::findOrFail($id)->forceDelete();
        $this->AdminlogActivity('Page', 'delete');

        return response()->json(['message'=>trans('api.record deleted successflly') ]);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id){
        Page::withTrashed()->findOrFail($id)->restore();
        $this->AdminlogActivity('Page', 'restore');

        return response()->json(['message'=>trans('api.record restored successflly') ]);
    }
    
}