<?php

namespace App\Http\Controllers\Api\AdminDashboard\NamazegCategories;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\AdminDashboard\NamazegCategories\StoreNamazegCategoryRequest;
use App\Http\Resources\AdminDashboard\NamazegCategory\NamazegCategoryResource;
use App\Http\Resources\Violation\NamazegResource;
use App\Models\NamazegCategory;
use App\Models\Namazeg;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;

class NamazegCategoryController extends Controller
{
    use LogsActivity;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:categories']);
    }

    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
        $data = NamazegCategory::with('subCategories')->where('parent_id',null);

        $queryParams = $request->query();
        if (!empty($queryParams)) {
            $data = Helper::filterData('App\Models\NamazegCategory', $queryParams, ['subCategories'])
            ->where('parent_id', null);
        }
        
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = NamazegCategoryResource::collection($data->paginate($perPage));

        return response()->json([
            'Namazegcategories' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

  

    /**
     * Display the specified resource.
     */
    public function getById(Request $request,$id)
    {
        // Start with the base query
        $data = Namazeg::where('namozeg_category_id',$id);

        // Retrieve all query parameters
        $queryParams = $request->query();
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\NamazegCategory', $filterData);
        }
        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = NamazegResource::collection($data->paginate($perPage));

        return response()->json(['namazeg' => $filterData, 'message' => trans('api.list of all available records')]);
    }
    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreNamazegCategoryRequest $request)
    {
        NamazegCategory::create($request->all());
        $this->AdminlogActivity('NamazegCategory', 'store', '/namazegCategories/get-all' );
        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(StoreNamazegCategoryRequest $request, $id)
    {
        NamazegCategory::findOrFail($id)->update($request->all());
        $this->AdminlogActivity('NamazegCategory', 'update', '/namazegCategories/get-all');
        return response()->json(['message'=>trans('api.record updated successflly') ]);
    }


    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id)
    {
        NamazegCategory::findOrFail($id)->delete();
        $this->AdminlogActivity('NamazegCategory', 'archive');

        return response()->json(['message' => trans('api.record archived successflly')]);
    }

    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id)
    {
        NamazegCategory::findOrFail($id)->forceDelete();
        $this->AdminlogActivity('NamazegCategory', 'delete');

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }

    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id)
    {
        NamazegCategory::withTrashed()->findOrFail($id)->restore();
        $this->AdminlogActivity('NamazegCategory', 'restore');

        return response()->json(['message' => trans('api.record restored successflly')]);
    }
}
