<?php

namespace App\Http\Controllers\Api\AdminDashboard\EducationalOffice;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\AdminDashboard\EducationalOffice\StoreEducationalOfficeRequest;
use App\Http\Requests\AdminDashboard\EducationalOffice\UpdateEducationalOfficeRequest;
use App\Http\Requests\UpdateStatusRequest;
use App\Http\Resources\AdminDashboard\EducationalDepartment\EducationalDepartmentResource;
use App\Http\Resources\AdminDashboard\EducationalOffice\EducationalOfficeResource;
use App\Models\AdminDashboard\EducationalDepartment\EducationalDepartment;
use App\Models\AdminDashboard\EducationalOffice\EducationalOffice;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;

class EducationalOfficeController extends Controller
{
        use LogsActivity;
        public function __construct()
        {
                //$this->middleware(['auth:api','permission:EducationalOffice']);
        }


        /**
         * Display a listing of the resource.
         */

         public function getAll(Request $request)
         {
             // Start with the base query
             $data = EducationalOffice::query();
     
             // Retrieve all query parameters
             $queryParams = $request->query();
     
             // Filter data is directly from query parameters, excluding `per_page`
             $filterData = array_filter($queryParams, function ($key) {
                 return $key !== 'per_page';
             }, ARRAY_FILTER_USE_KEY);
     
             // Apply filters if any
             if (!empty($filterData)) {
                 $data = Helper::filterData('App\Models\AdminDashboard\EducationalOffice\EducationalOffice', $filterData);
             }
     
             // Paginate results with a default value if not provided
             $perPage = $queryParams['per_page'] ?? 15;
     
             $filterData = EducationalOfficeResource::collection($data->paginate($perPage));
     
     
             return response()->json([
                 'educationalOffices' => $filterData,
                 'message' => trans('api.list of all available records'),
             ]);
         }
       

        /**
         * Show the form for creating a new resource.
         */
        public function create()
        {

                $educationalDepartments = EducationalDepartmentResource::collection(EducationalDepartment::all());
                
                return response()->json(['educationalDepartments' => $educationalDepartments], 200);
        }

        /**
         * Store a newly created resource in storage.
         */
        public function store(StoreEducationalOfficeRequest $request)
        {

                $data = $request->validated();

                $EducationalOffice = EducationalOffice::create($data);
                $this->AdminlogActivity('EducationalOffice', 'store', '/educational - offices/' . $EducationalOffice->id . '/details');

                return response()->json(['message' => trans('api.record stored successflly')], 200);
        }

        /**
         * Display the specified resource.
         */
        public function getById(EducationalOffice $educationalOffice)
        {
                $educationalOffice =  new EducationalOfficeResource($educationalOffice);

                return  response()->json(['educationalOffice' => $educationalOffice], 200);
        }

        /**
         * Show the form for editing the specified resource.
         */
        public function edit(EducationalOffice $educationalOffice)
        {

                $educationalOffice = new EducationalOfficeResource($educationalOffice);

                return  response()->json(['educationalOffice' => $educationalOffice], 200);
        }

        /**
         * Update the specified resource in storage.
         */
        public function update(UpdateEducationalOfficeRequest $request, EducationalOffice $educationalOffice)
        {

                $data = $request->validated();

                $educationalOffice->update($data);
                $this->AdminlogActivity('EducationalOffice', 'update', '/educational - offices/' . $educationalOffice->id . '/details');

                return response()->json(['message' => trans('api.record updated successflly')], 200);
        }
        /* this method will change activation status for
       specific Model recored by using ID
    */
        public function changeStatus(UpdateStatusRequest $request, EducationalOffice $educationalOffice)
        {

                $educationalOffice->status = $request->status;

                $educationalOffice->save();

                return response()->json(['message' => trans('api.record updated successflly')], 200);
        }

        /**
         * Soft Delete.
         */
        public function archive(EducationalOffice $educationalOffice)
        {

                $educationalOffice->delete();
                $this->AdminlogActivity('EducationalOffice', 'archive');
                return response()->json(['message' => trans('api.record archived successflly')], 200);
        }

        /**
         * Remove the specified resource from storage.
         */
        public function destroy(EducationalOffice $educationalOffice)
        {

                $educationalOffice->forceDelete();
                $this->AdminlogActivity('EducationalOffice', 'delete');

                return response()->json(['message' => trans('api.record deleted successflly')], 200);
        }
        /**
         * restore the specified resource which soft Deleted.
         */
        public function restore(EducationalOffice $educationalOffice)
        {

                $educationalOffice->restore();
                $this->AdminlogActivity('EducationalOffice', 'restore');
                return response()->json(['message' => trans('api.record restored successflly')], 200);
        }
}
