@extends('layouts.master')

@section('title', 'New Branch | Proxima - Medical Management app')

@section('title-topbar', 'New Branch')

<!-- css insert -->
@section('css')
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.3/dist/leaflet.css"
    integrity="sha256-kLaT2GOSpHechhsozzB+flnD+zUyjE2LlfWPgU04xyI=" crossorigin="" />
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
    .wrap {
        width: 1200px;
        margin: 30px auto;
        display: grid;
        grid-gap: 50px;
        grid-template-columns: 300px auto;
    }

    #map {
        width: 100%;
        height: 350px;
        border-radius: 10px;
    }
</style>
@endsection


<!-- content insert -->
@section('content')

<div class="container-fluid px-0 px-md-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.branchcat.index') }}">Branches | </a>
            <a class="text-gray-300">New Branch</a>
        </span>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-map-marker-alt me-1"></i> New Branch</h6>
        </div>


        <!-- Card Body -->
        <div class="card-body px-4 px-md-5">

            <form id="myform" method="POST" action="{{ route('sett.branchcat.store') }}">

                @csrf

                <div class="row mb-1 justify-content-center">

                    <div class="col-12 col-md-10 col-lg-7">
                        <div class="row">

                            <div class="row">

                                <div class="col-6 mb-3">
                                    <label class="form-label">Name
                                        <small>({{ __('basic.required') }})</small></label>
                                    <input name="name" type="text"
                                        class="form-control @error('name') is-invalid @enderror"
                                        placeholder="Branch Name.." required>

                                    @error('name')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-6 mb-4">
                                    <label class="form-label">Branch Code
                                        <small>({{ __('basic.required') }})</small></label>
                                    <input name="branch_code" type="text"
                                        class="form-control @error('branch_code') is-invalid @enderror" maxlength="3"
                                        placeholder="Branch Code..">
                                    <div class="form-text text-gray-200">
                                        The Maximum branch code is 3 characters
                                    </div>
                                    @error('branch_code')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>

                            </div>
                            <div class="col-12 mb-2">
                                    <label class="form-label">Default Money Per Pulse Service
                                    <small>({{ __('basic.optional') }})</small>
                                    </label>
                                    <select
                                        class="js-example-basic-single  select2-hidden-accessible @error('service') is-invalid @enderror"
                                        id="service" name="service">
                                            @foreach ($services as $item)
                                            <option value="{{ $item->id }}">
                                            {{ $item->name }}
                                            </option>
                                            @endforeach
                                    </select>
                            </div>


                            <div class="col-12 mb-3">
                                <label class="form-label">Address
                                    <small>({{ __('basic.required') }})</small></label>
                                <input name="address" type="text"
                                    class="form-control @error('address') is-invalid @enderror"
                                    placeholder="Branch Address.." required>

                                @error('address')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label">Phone Number
                                <small>({{ __('basic.optional') }})</small></label>
                                <input name="phone_number" type="text"
                                    class="form-control @error('phone_number') is-invalid @enderror"
                                    placeholder="Branch Phone Number..">

                                @error('phone_number')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-4">
                                <label class="form-label">Second Phone Number
                                   <small>({{ __('basic.optional') }})</small></label>
                                <input name="sec_phone_number" type="text"
                                    class="form-control @error('sec_phone_number') is-invalid @enderror"
                                    placeholder="Branch Second Phone Number..">

                                @error('sec_phone_number')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="row">
                                <div class="col-8">
                                    <div id="map"></div>
                                </div>
                                <div class="col-4">
                                    <div class="col-12 mb-3">
                                        <label class="form-label">Latitude
                                            <small>({{ __('basic.required') }})</small></label>
                                        <input name="latitude" type="text" id="latitude"
                                            class="form-control @error('latitude') is-invalid @enderror"
                                            placeholder="Branch Latitude.." required>

                                        @error('latitude')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>
                                    <div class="col-12 mb-3">
                                        <label class="form-label">Longitude
                                            <small>({{ __('basic.required') }})</small></label>
                                        <input name="longitude" type="text" id="longitude"
                                            class="form-control @error('longitude') is-invalid @enderror"
                                            placeholder="Branch Longitude.." required>

                                        @error('longitude')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-end mt-4 mb-2">
                    <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                        value="Send">
                </div>

            </form>
        </div>

    </div>

</div>

@endsection

<!-- js insert -->
@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/leaflet/1.9.3/leaflet.js"></script>
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
    $('.js-example-basic-single').select2({
        width: 'element'
    });

</script>
<script>
    let mapOptions = {
    center:[30.033333, 31.233334],
    zoom:11
}

let map = new L.map('map' , mapOptions);

let layer = new L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
    maxZoom: 19,
    attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
}).addTo(map);


let marker = null;
map.on('click', (event)=> {

    if(marker !== null){
        map.removeLayer(marker);
    }

    marker = L.marker([event.latlng.lat , event.latlng.lng]).addTo(map);

    document.getElementById('latitude').value = event.latlng.lat;
    document.getElementById('longitude').value = event.latlng.lng;

})


// Circle
// L.circle([30.135514886428,31.190614700317383],
//          1000,
//         {color: 'red',
//          fillColor: '#f03',
//          fillOpacity: 0.5}).addTo(map);

// var polygon = L.polygon([
//     [30.065489589985653, 31.21525481343269],
//     [30.071951952621944, 31.22160628437996],
//     [30.05315793433407, 31.226927787065502]
// ]).addTo(map);

</script>

<!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
        var $validator = $('#myform').validate({
            rules: {
                name: {
                    minlength: 3,
                },
                address: {
                    minlength: 3,
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'gendar':
                        error.insertAfter($("#gendar-js-error-valid"));
                        break;
                    default:
                        error.insertAfter(element);
                }

            },
        });
</script>

@endsection
