@extends('layouts.master')

@section('title', 'Users')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

@endsection


<!-- content insert -->
@section('content')
<div class="container-fluid px-2 ">
    <div class="card card-input shadow mb-4">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold">Add new user</h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Dropdown Header:</div>
                    <a class="dropdown-item" href="#">Action</a>
                </div>
            </div>
        </div>

        <!-- Card Body -->
        <div class="card-body p-5">

            <div class="row mb-1">
                <div class="col-12 col-md-5 align-self-center mb-2">
                    <div class="avatar-update-container">
                        <div class="picture">
                            <img src="{{ URL::asset('img/dashboard/avatars/default-pp.png') }}" class="picture-src"
                                id="mib_PicturePreview" title="" />
                            <input type="file" accept="image/*" id="mib_img_input">
                        </div>
                        <h6 class="text-gray-300">Choose Picture</h6>
                    </div>
                </div>

                <div class="col-12 col-md-7 mb-2">
                    <div class="mb-3">
                        <label class="form-label">First Name <small>(required)</small></label>
                        <input name="firstname" type="text" class="form-control" placeholder="Ahmed..." required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Last Name <small>(required)</small></label>
                        <input name="lastname" type="text" class="form-control" placeholder="Yousef..." required>
                    </div>
                </div>

            </div>

            <div class="row mb-2">
                <div class="col-12 col-md-6 mb-2">
                    <label class="form-label">Email <small>(required)</small></label>
                    <input name="email" type="email" class="form-control" placeholder="Write your email here" required>
                    <div class="form-text text-gray-200">We'll never share your email with anyone else.</div>
                </div>
                <div class="col-12 col-md-6 mb-2">
                    <label class="form-label">Branch <small>(required)</small></label>
                    <select class="selectpicker wide" name="branch" required>
                        <option selected>Open this select menu</option>
                        <option value="1">One</option>
                        <option value="2">Two</option>
                        <option value="3">Three</option>
                    </select>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-12 col-md-6 mb-2">
                    <label class="form-label">Password <small>(required)</small></label>
                    <input name="password" type="password" class="form-control"
                        placeholder="Wrtie your password here..." required>
                    <div class="form-text text-gray-200">We'll never share your email with anyone else.</div>
                </div>
                <div class="col-12 col-md-6 mb-2">
                    <label class="form-label">Confirm password <small>(required)</small></label>
                    <input name="lastname" type="password" class="form-control" placeholder="Confirm your password..."
                        required>
                </div>
            </div>

            <hr>

            <label class="mb-3 text-gray-400">Personal information</label>

            <div class="row mb-2">
                <div class="col-12 col-md-6 mb-2">
                    <label class="form-label">Phone Number <small>(required)</small></label>
                    <input name="password" type="password" class="form-control"
                        placeholder="Wrtie your password here..." required>
                    <div class="form-text text-gray-200">We'll never share your password with anyone else.</div>
                </div>
                <div class="col-12 col-md-6 mb-2">
                    <label class="form-label">Second Phone Number <small>(required)</small></label>
                    <input name="lastname" type="password" class="form-control" placeholder="Confirm your password..."
                        required>
                </div>
            </div>

            <hr>

            <div class="row mb-2">
                <div class="col-12 col-md-4 mb-2">
                    <label class="form-label">city <small>(required)</small></label>
                    <select class="js-example-basic-single select2-no-search select2-hidden-accessible" name="country"
                        required>
                        <option selected>Open this select menu</option>
                        <option value="1">One</option>
                        <option value="2">Two</option>
                        <option value="3">Three</option>
                    </select>
                </div>
                <div class="col-12 col-md-4 mb-2">
                    <label class="form-label">city <small>(required)</small></label>
                    <select class="js-example-basic-single select2-no-search select2-hidden-accessible" name="country"
                        required>
                        <option selected>Open this select menu</option>
                        <option value="1">One</option>
                        <option value="2">Two</option>
                        <option value="3">Three</option>
                    </select>
                </div>
                <div class="col-12 col-md-4 mb-2">
                    <label class="form-label">city <small>(required)</small></label>
                    <select class="js-example-basic-single select2-hidden-accessible" name="country" required>
                        <option selected>Open this select menu</option>
                        <option value="1">One</option>
                        <option value="2">Two</option>
                        <option value="3">Three</option>
                    </select>
                </div>
            </div>

            <div class="row mb-2">
                <div class="mb-3">
                    <label class="form-label">Note <small>(optional)</small></label>
                    <textarea name="note" class="form-control" placeholder="Write here your notes .." rows="4"
                        spellcheck="false"></textarea>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

<!-- js insert -->
@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
</script>


@endsection