<?php
use App\Http\Controllers\Branch\AppointmentController;
use App\Http\Controllers\Branch\OperationController;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

Route::group(
    [
         'prefix' => LaravelLocalization::setLocale(),
         'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
    ],
    function () {

        Route::prefix('prox')->name('sett.')->group(function () {
            Route::group(['prefix' => 'appo', 'middleware' => ['role:Super-admin|Branch-manager|Receptionist|Call-center|Doctor|Operation|Operation_doctor']], function () {

                /*
                |--------------------------------------------------------------------------
                | Appointment Operations
                |--------------------------------------------------------------------------
                */
                //MAIN appointments resource routes
                    Route::resource('/appointment', AppointmentController::class);
                    //appointments for operation
                    Route::resource('/operation', OperationController::class)->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                //Appointment API routes
                    //GET Routes
                        //get the services for appointment
                        Route::get('/fetch_unit_ajax/{branch_id}', [AppointmentController::class, 'fetch_unit_ajax'])->name('app_fetch_unit_ajax');

                        //get the services for appointment
                        Route::get('/fetch_servicecat_ajax/{specialty_id}/{branch_id}', [AppointmentController::class, 'fetch_servicecat_ajax'])->name('app_fetch_servicecat_ajax');

                        //get the appointment info from the timeslot
                        Route::get('/appointment_info_ajax/{id}', [AppointmentController::class, 'appointment_info_ajax'])->name('app_appointment_info_ajax');

                        //waiting in branch data
                        Route::get('/witing_branch_data', [AppointmentController::class, 'witing_branch_data'])->name('app_witing_branch_data');
                        //patients waiting to enter the doctors page
                        Route::get('/withdoctor_data', [AppointmentController::class, 'withdoctor_data'])->name('app_withdoctor_data');

                        //patients waiting to enter the doctors page
                        Route::get('/rate_show', [AppointmentController::class, 'rate_show'])->name('app_rate_show');

                    // PUT/PATCH/POST Requests Routes
                        //update appointment note
                        Route::put('/appointment_note/{id}', [AppointmentController::class, 'appointment_note'])->name('app_appointment_note');

                        //update appointment status
                        Route::PATCH('/update_status_doctor/{id}', [AppointmentController::class, 'update_status_doctor'])->name('app_update_status_doctor');

                        //to queue_show update to be shown
                        Route::PATCH('/queue_show_update/{id}', [AppointmentController::class, 'queue_show_update'])->name('app_queue_show_update');

                        //update the appointment status to 2 (arrived)
                        Route::PATCH('/arrived_patient_qr_update/{patient_username}', [AppointmentController::class, 'arrived_patient_qr_update'])->name('app_arrived_patient_qr_update');

                        Route::PUT('/withdoctor_service_save', [AppointmentController::class, 'withdoctor_service_save'])->name('app_withdoctor_service_save');
                        Route::PUT('/withdoctor_service_save_session', [AppointmentController::class, 'withdoctor_service_save_session'])->name('app_withdoctor_service_save_session');
                        //update status to 4 in patients waiting to enter the doctors page
                        Route::PATCH('/withdoctor_update/{id}', [AppointmentController::class, 'withdoctor_update'])->name('app_withdoctor_update');
                        //store past appointment
                        Route::post('/past_appointment', [AppointmentController::class, 'past_appointment'])->name('app_past_appointment');
                        //--------
                        Route::post('/follow_up_app_index', [AppointmentController::class, 'follow_up_app_index'])->name('follow_up_app_index')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor|Receptionist']);;
                        //update status to 4 in patients waiting to enter the doctors page
                        Route::PATCH('/rate_update/{appointment_id}', [AppointmentController::class, 'rate_update'])->name('app_rate_update');
                //Appointment routes that return VIEWS
                    //waiting in branch view
                    Route::get('/witing_branch', [AppointmentController::class, 'witing_branch'])->name('app_witing_branch');
                    //stat for appointments
                    Route::get('/allstatcs/{specialty?}/{branch?}/{from?}/{to?}', [AppointmentController::class, 'allstatcs'])->name('app_allstatcs')->middleware(['role:Super-admin']);

                    //stat for appointments
                    Route::get('/all_appointments/{specialty?}/{branch?}/{from?}/{to?}', [AppointmentController::class, 'all_appointments'])->name('all_appointments');
                    // qr reader view
                    Route::get('/arrived_patient_qr', [AppointmentController::class, 'arrived_patient_qr'])->name('app_arrived_patient_qr');
                    //patients waiting to enter the doctors page
                    Route::get('/withdoctor', [AppointmentController::class, 'withdoctor'])->name('app_withdoctor');
                    //patients waiting to enter the doctors page
                    Route::get('/withdoctor_service', [AppointmentController::class, 'withdoctor_service'])->name('app_withdoctor_service');
                    //rate system
                    Route::get('/rate', [AppointmentController::class, 'rate_index'])->name('app_rate');

                //Appointment Calender routes

                    //routes for render calander html code
                    Route::get('/calander_appointment_ajax/{month}/{year}/{specialty_id}/{branch_id}/{unit_id}', [AppointmentController::class, 'calander_appointment_ajax'])->name('appcalander_appointment_ajax');

                    //route for rendering calander's time slots
                    Route::get('/calander_show_slots_ajax/{datetoday}/{specialty_id}/{branch_id}/{unit_id}', [AppointmentController::class, 'calander_show_slots_ajax'])->name('appcalander_show_slots_ajax');

                    //patient search engine while creating appointment
                    Route::get('/calander_patient_search/{search_query}', [AppointmentController::class, 'calander_patient_search'])->name('app_calander_patient_search');

                    //weekly calander
                    Route::get('/weekly_calender/{yearin}/{weekin}', [AppointmentController::class, 'weekly_calender'])->name('app_weekly_calender');
                    //weekly calander timeslots
                    Route::get('/weekly_calender_date/{year}/{month}/{day}/{specialty}/{branch}/{unit}/{order}/{search}', [AppointmentController::class, 'weekly_calender_date'])->name('app_weekly_calender_date');

                    //weekly calander timeslots get total services in the day
                    Route::get('/weekly_calender_date_total_services/{year}/{month}/{day}/{specialty}/{branch}', [AppointmentController::class, 'weekly_calender_date_total_services'])->name('app_weekly_calender_date_total_services');

                    //weekly calander timeslots
                    Route::get('/monthly_calendar_show', [AppointmentController::class, 'monthly_calendar_show'])->name('app_monthly_calendar_show');

                    //update calendar sortable drag and drop
                    Route::post('/sortable_calendar_update/{id}', [AppointmentController::class, 'sortable_calendar_update'])->name('sortable_calendar_update');

                    //fetch the monthly calendar
                    Route::get('/monthly_calendar_data/{year}/{month}/{specialty}/{branch}/{unit}', [AppointmentController::class, 'monthly_calendar_data'])->name('app_monthly_calendar_data');
                //Operation Appointments Calender routes
                    //ajax for calander
                    Route::get('/calander_show_slots_ajax_op/{datetoday}/{specialty_id}/{branch_id}', [OperationController::class, 'calander_show_slots_ajax_op'])->name('calander_show_slots_ajax_op');

                    //ajax for operation calander
                    Route::get('/calander_appointment_ajax_operation/{month}/{year}/{specialty_id}/{oper_place_id}', [OperationController::class, 'calander_appointment_ajax_operation'])->name('app_calander_appointment_ajax_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                    //weekly calander timeslots for operation
                    Route::get('/weekly_calender_date_operation/{year}/{month}/{day}/{specialty}/{branch}/{order}', [OperationController::class, 'weekly_calender_date_operation'])->name('app_weekly_calender_date_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                    //fetch the monthly calendar
                    Route::get('/monthly_calendar_data_operation/{year}/{month}/{specialty}/{branch}', [OperationController::class, 'monthly_calendar_data_operation'])->name('app_monthly_calendar_data_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;






            //rate appointment
            // Route::resource('/rate', RateController::class);



                //complaints
                Route::resource('/complaint', ComplaintController::class);
                Route::get('/complaint_show_ajax', [ComplaintController::class, 'complaint_show_ajax'])->name('comp_complaint_show_ajax');
                Route::post('/complaint_save_ajax', [ComplaintController::class, 'complaint_save_ajax'])->name('comp_complaint_save_ajax');

           });


        });
    });



