@extends('layouts.master')

@section('title', $patient->first_name . ' ' . $patient->second_name . ' | Proxima - Medical Management app')
@section('title-topbar', __('patientappo.patient profile'))

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- datepicker time and date -->
<link rel="stylesheet" href="https://fastly.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">


<!-- toaster -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css" rel="stylesheet" />
@endsection


@section('fixedcontent')

<!-- session successful message -->
@if (Session::has('success'))
<div id="flash-msg" class=" shadow-lg pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Done</h3>
    <p class="text-blue-300">{{ Session::get('success') }}</p>
</div>
@else
@role('Super-admin|Doctor|Branch-manager|Receptionist')
<div id="flash-msg-hide" class="patient_popup_window pt-3">
    <div class="d-flex justify-content-end mb-2">
        <a id="flash-msg-hide-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fs-3 fa-times"></i></a>
    </div>
    <div class="row">
        <div class="col-7">
            <h2 class="fw-bold">It's {{ $patient->first_name }}'s Profile</h2>
            <p class="text-blue-300">
                Add new Info related to the appointment by choosing from below
            </p>

            <div class="d-flex">
                <button type="button" class="btn btn-primary add_info_old_appo me-2">
                    Old appointment
                </button>

                <button type="button" class="btn btn-primary add_info_exsit_appo">
                    Existing appointment
                </button>
            </div>
        </div>

        <div class="col-5">
            <img class="w-100" src="{{ URL::asset('img/dashboard/undraw_teacher_re_sico.svg') }}">
        </div>

    </div>
</div>
@endrole
@endif

<!-- session successful message -->
@if (Session::has('error_delete'))
<div id="flash-msg" class="shadow pt-3" style="background-color:#ff4152;">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-times"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"
                style="color:#ffb4bc"></i></a>
    </div>
    <h3>Can not be deleted</h3>
    <p style="color:#ffb4bc">{{ Session::get('error_delete') }}</p>
</div>
@endif
@endsection

<!-- content insert -->
@section('content')

<div class="container-fluid px-0">

    <!-- msg success -->
    <div id="flash-msg-cont"></div>

    @foreach ($errors->all() as $error)
    <div class="text-red"><i class="fas fa-exclamation me-1"></i> {{ $error }}</div>
    @endforeach

    <!-- page title link -->
    <div class="d-flex flex-wrap align-items-center justify-content-between mb-3">

        <!-- page title link -->
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">{{ __('basic.dashboard') }}
                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.patient.index') }}">{{
                __('basic.patient') }} | </a>
            <a class="text-gray-300">{{ $patient->first_name }}</a>
        </span>

        <div class="d-flex flex-wrap justify-content-center mt-2">


            @role('Super-admin|Doctor|Branch-manager|Receptionist|Operation')
            <a data-bs-toggle="modal" data-bs-target="#send_sms"
                class="bg-white text-gray-400 btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-2 mb-2 mb-md-0"><i
                    class="fas fa-mobile-alt fa-sm me-1"></i> SMS</a>

            <div class="modal fade" id="send_sms" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="{{ route('sett.pat_sms_form_profile', $patient->id) }}" method="GET"
                        style="display: contents">

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-mobile-alt me-1"></i>
                                    {{ __('patientappo.send sms') }}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">
                                    <div class="col-12 mb-2">
                                        <label class="form-label">{{ __('patientappo.sms content') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <textarea name="sms_content" class="form-control"
                                            placeholder="Write here your the sms content .." rows="4"
                                            spellcheck="false"></textarea>

                                        @error('sms_content')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">{{
                                        __('basic.send') }}</button>
                                </div>
                            </div>

                        </div>
                    </form>

                </div>

            </div>

            <a href="{{ route('sett.patient.edit', $patient->id) }}"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2 mb-2 mb-md-0"><i
                    class="fas fa-user-edit fa-sm text-gray-300 me-1"></i> {{ __('basic.edit') }}</a>


            <div class="dropdown no-arrow">
                <a href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-haspopup="true"
                    aria-expanded="false"
                    class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2 mb-2 mb-md-0"><i
                        class="fas fa-search fa-sm text-gray-300 me-2"></i> {{ __('basic.investigation') }}</a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Type Of Prints:</div>

                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="{{ route('sett.investigation_print_no_frame_a5', [$patient->id, 1]) }}">
                        {{ __('basic.radiology investigation with no frame A5') }}</a>

                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="{{ route('sett.investigation_print_no_frame_a5', [$patient->id, 2]) }}">
                        {{ __('basic.lab investigation with no frame A5') }}</a>

                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="{{ route('sett.investigation_print', [$patient->id, 1]) }}">
                        {{ __('basic.radiology investigation with frame A4') }}</a>

                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="{{ route('sett.investigation_print', [$patient->id, 2]) }}">
                        {{ __('basic.lab investigation with frame A4') }}</a>
                </div>
            </div>


            <div class="dropdown no-arrow">
                <a href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-haspopup="true"
                    aria-expanded="false"
                    class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2 mb-2 mb-md-0"><i
                        class="fas fa-glasses fa-sm text-gray-300 me-2"></i> {{ __('basic.eyeglasses') }}</a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Type Of Prints:</div>
                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="{{ route('eyeglasses_presc_print_no_frame', $patient->code) }}">
                        {{ __('basic.eyeglasses with no frame A4') }}</a>
                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="{{ route('eyeglasses_presc_print_no_frame_a5', $patient->code) }}">
                        {{ __('basic.eyeglasses with no frame A5') }}</a>
                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="{{ route('eyeglasses_prescription_print', $patient->code) }}">
                        {{ __('basic.eyeglasses with frame A4') }}</a>
                </div>
            </div>

            <div class="dropdown no-arrow">
                <a href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-haspopup="true"
                    aria-expanded="false"
                    class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2 mb-2 mb-md-0"><i
                        class="fas fa-capsules fa-sm text-gray-300 me-2"></i> {{ __('patientappo.presc') }}</a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">
                    <div class="dropdown-header">Type Of Prints:</div>
                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="{{ route('pat_patient_print_pre_no_frame', $patient->code) }}">
                        {{ __('basic.prescription with no frame A5') }}</a>
                    <a class="dropdown-item clickable-item-pointer" target="_blank"
                        href="{{ route('pat_patient_print_pre', $patient->code) }}">
                        {{ __('basic.prescription with frame A5') }}</a>
                </div>
            </div>

            <a href="{{ route('sett.ramad_examination_print', $patient->id) }}"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 me-2 mb-2 mb-md-0"><i
                    class="fas fa-x-ray fa-sm text-gray-300 me-2"></i> {{ __('basic.examination') }}</a>


            <a href="{{ route('sett.pat_patient_print', $patient->id) }}"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i
                    class="fas fa-download fa-sm text-gray-300 me-2"></i> {{ __('basic.profile') }}</a>

            <a id="print_qr" data-id="{{ $patient->id }}"
                class="bg-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400 ms-2"><i
                    class="fas fa-sticky-note fa-sm text-gray-300 me-1"></i> {{ __('basic.barcode') }}</a>

            <!-- confirm Modal -->
            <div class="modal fade" id="print_qty_qr" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable ">
                    <div class="modal-content b-r-s-cont border-0">

                        <div class="modal-header">
                            <div class="modal-title" id="exampleModalLabel"><i class="fas fa-box-open me-1"></i>
                                {{ __('basic.how many sticker you want to print') }}</div>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <!-- Modal content -->
                        <div class="modal-body px-4">

                            <div class="modal-body delete-conf-input text-center d-flex py-0">

                                <select id="print_sticker_qty"
                                    class="myselect2-record-insert myselect2-sticker-insert-nosearch select2-hidden-accessible @error('qty') is-invalid @enderror"
                                    id="type" name="print_sticker_qty" required>
                                    @for($i = 1; $i <= 20; $i++) <option value="{{ $i }}">{{ $i }}</option>
                                        @endfor
                                </select>
                                <input type="hidden" name="print_sticker_patient_id" id="print_sticker_patient_id"
                                    value="">
                            </div>
                        </div>

                        <div class="modal-footer">
                            <div class="right-side">
                                <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                    __('basic.never mind') }}</button>
                            </div>
                            <div class="divider"></div>
                            <div class="left-side">
                                <button id="print_qr_btn"
                                    class="btn btn-default btn-link text-green">{{__('basic.print') }}
                                </button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            @endrole


            @role('Super-admin')
            <a data-bs-toggle="modal" data-bs-target="#delete_patient"
                class="bg-white text-gray-400 btn btn-sm shadow-sm b-r-l-cont p-2 px-4 ms-2 mb-2 mb-md-0"><i
                    class="fas fa-trash-alt fa-sm me-1"></i> Delete</a>

            <div class="modal fade" id="delete_patient" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="{{ route('sett.patient.destroy', $patient->id) }}" method="post"
                        style="display: contents">
                        {{ method_field('delete') }}
                        {{ csrf_field() }}

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-trash-alt me-1"></i>
                                    {{ __('basic.delete patient') }}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row mb-2">

                                    <div class="col-12 mb-2">
                                        هل انت متاكد من حذف المريض؟ سوف يتم مسح معظم عملياته في النظام
                                    </div>

                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                        __('basic.never mind') }}</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">{{
                                        __('basic.delete') }}</button>
                                </div>
                            </div>

                        </div>
                    </form>

                </div>

            </div>
            @endrole
        </div>

    </div>

    <!-- welcome msg & note -->
    <div class="row mb-4">
        <div class="col-lg-8 col-sm-12">
            <div class="card shadow mb-4 mb-lg-0">

                <!-- Card Body -->
                <div class="card-body row">
                    <div class="col align-self-center border-flex ps-3">

                        <div class="d-flex mb-4 align-items-center">
                            <div class="position-relative">
                                @if ($patient->recommendation == 1)
                                @php
                                $recom_color = 'main-color-bg-200';
                                $recom_msg = __('basic.normal');
                                @endphp
                                @elseif ($patient->recommendation == 2)
                                @php
                                $recom_color = 'text-green-ligh-bg';
                                $recom_msg = __('basic.recommended');
                                @endphp
                                @elseif ($patient->recommendation == 3)
                                @php
                                $recom_color = 'text-red-bg';
                                $recom_msg = __('basic.not recommended');
                                @endphp
                                @endif
                                <img class="rounded-circle avatar-lg me-3"
                                    src="{{ URL::asset('img/useravatar/' . $patient->avatar) }}">
                                <div data-toggle="tooltip" data-placement="top" title="{{ $recom_msg }}"
                                    class="status-indicator-img {{ $recom_color }}"></div>
                            </div>
                            <div class="">
                                <h5 class="mb-1 fw-bold text-gray-600">
                                    {{ $patient->first_name . ' ' . $patient->second_name }}</h5>
                                <p class="mb-0 text-xs text-gray-400">{{ __('basic.file number') }}: <strong>
                                        {{ $patient->new_id }}</strong></p>
                                <p class="mb-0 text-xs text-gray-400">{{ __('basic.code') }}: <strong>
                                        {{ $patient->code }}</strong></p>
                            </div>
                        </div>

                        <div class="d-flex ps-2 justify-content-between">

                            <div class="align-items-center text-center">
                                <p class="text-xxs fw-normal mb-1 text-gray-400">{{ __('patientappo.weight') }}</p>
                                <span class="text-s2 fw-bold text-gray-600"><i
                                        class="fas fa-child fa-sm fa-fw text-gray-300"></i>
                                    {{ $patient->height }}<small class="text-xxs text-gray-200">cm</small></span>
                            </div>

                            <div class="align-items-center text-center me-2">
                                <p class="text-xxs fw-normal mb-1 text-gray-400">{{ __('patientappo.height') }}</p>
                                <span class="text-s2 fw-bold text-gray-600"><i
                                        class="fas fa-weight-hanging fa-sm fa-fw text-gray-300"></i>
                                    {{ $patient->weight }}<small class="text-xxs text-gray-200">kg</small></span>
                            </div>
                            <div class="align-items-center text-center  ">
                                <p class="text-xxs fw-normal mb-1 text-gray-400">P {{ __('basic.balance') }}</p>
                                <span class="text-s2 fw-bold text-gray-600"><i
                                        class="fas fa-thermometer fa-sm fa-fw text-gray-300"></i>
                                    {{ $patient->balance }}<small class="text-xxs text-gray-200">pts</small></span>
                            </div>

                            <div class="align-items-center text-center  ">
                                <p class="text-xxs fw-normal mb-1 text-gray-400">{{ __('patientappo.wallet') }}</p>
                                <span class="text-s2 fw-bold text-gray-600"><i
                                        class="fas fa-wallet fa-sm fa-fw text-gray-300"></i>
                                    {{ $patient->wallet }}<small class="text-xxs text-gray-200">egp</small></span>
                            </div>

                        </div>
                    </div>


                    <div class="col-12 col-sm ps-4 pt-3">

                        <div id="patient-info-caro" class="carousel slide" data-bs-ride="carousel"
                            data-bs-interval="false">

                            <div class="carousel-indicators dots-radius-carousel"
                                style="bottom: -28px; margin-bottom: 0px;">
                                <button type="button" data-bs-target="#patient-info-caro" data-bs-slide-to="0"
                                    class="active" aria-current="true" aria-label="Slide 1"></button>
                                <button type="button" data-bs-target="#patient-info-caro" data-bs-slide-to="1"
                                    aria-label="Slide 2"></button>
                            </div>

                            <div class="carousel-inner mb-3">

                                <!-- info 1 -->
                                <div class="carousel-item active">

                                    <div class="row mb-2">
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.age') }}</h6>
                                            <p class="text-gray-600 text-s fw-bold">
                                                {{
                                                \Carbon\Carbon::parse($patient->birthday)->diff(\Carbon\Carbon::now())->format('%y
                                                Years') }}
                                            </p>
                                        </div>
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.address') }}</h6>
                                            <p class="text-gray-600 text-s fw-bold">{{ $patient->city->name }} ,
                                                {{ $patient->country->name }}</p>
                                        </div>
                                    </div>

                                    <div class="row mb-2">
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.ph number') }}
                                            </h6>
                                            <p class="text-gray-600 text-xs fw-bold">{{ $patient->phone_number }}
                                            </p>
                                        </div>
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.branch') }}
                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold">{{ $patient->branch->name }}</p>
                                        </div>
                                    </div>

                                    <div class="row">

                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.file branch number') }}
                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold">{{ $patient->new_branch_id }}
                                            </p>
                                        </div>


                                        <div class="col pt-3">
                                            <p class="@if ($patient->note) text-green-ligh
                                                    @else
                                                    main-color @endif
                                                    text-xs fw-bold clickable-item-pointer" data-bs-toggle="modal"
                                                data-bs-target="#patient_note"><i class="fas fa-comment-alt"></i>
                                                {{ __('basic.note') }}

                                                @if ($patient->note)
                                                <span class="badge rounded badge-danger badge-counter"
                                                    style="border-radius: 50% !important;height: 15px;width: 15px;padding: 3px !important;">1</span>
                                                @endif

                                            </p>

                                            <!-- Modal -->
                                            <div class="modal fade" id="patient_note" tabindex="-1"
                                                aria-labelledby="exampleModalLabel2" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                                    <div class="modal-content b-r-s-cont border-0">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="exampleModalLabel2"><i
                                                                    class="fas fa-quote-left me-1"></i>
                                                                {{ __('patientappo.patient note') }}</h5>
                                                            <button type="button" class="btn-close"
                                                                data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>

                                                        <!-- Modal content -->
                                                        <div class="modal-body px-4">
                                                            <div class="mb-3">
                                                                <label class="form-label">{{ __('basic.note') }}
                                                                    <small></small></label>
                                                                <textarea name="note" class="form-control"
                                                                    placeholder="Write here your notes .." rows="4"
                                                                    spellcheck="false"
                                                                    date-text="Write here your notes ..">{{ $patient->note }}</textarea>
                                                            </div>
                                                        </div>

                                                        <div class="modal-footer">
                                                            <div class="left-side">
                                                                <button type="button" class="btn btn-default btn-link"
                                                                    data-bs-dismiss="modal">{{ __('basic.never mind')
                                                                    }}</button>
                                                            </div>
                                                            <div class="divider"></div>
                                                            <div class="right-side">
                                                                <button type="button" id="note_ajax"
                                                                    class="btn btn-default btn-link main-color"
                                                                    data-bs-dismiss="modal">{{ __('basic.save changes')
                                                                    }}</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- info 2 -->
                                <div class="carousel-item">

                                    <div class="row mb-2">

                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">
                                                {{ __('patientappo.sec ph number') }}
                                            </h6>
                                            <p class="text-gray-600 text-xs fw-bold">
                                                {{ $patient->sec_phone_number }}
                                            </p>
                                        </div>

                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.resource') }}
                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold">{{ $patient->recourse->name }}
                                            </p>
                                        </div>
                                    </div>

                                    <div class="row mb-2">
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.insurance') }}
                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold">{{ $patient->insurance }}</p>
                                        </div>
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">
                                                {{ __('basic.status') }}</h6>
                                            <p class="text-gray-600 text-s fw-bold">
                                                @if ($patient->type == 1)
                                                {{ __('basic.patient') }}
                                                @elseif ($patient->type == 2)
                                                {{ __('basic.leads no action') }}
                                                @elseif ($patient->type == 3)
                                                {{ __('basic.leads interested') }}
                                                @elseif ($patient->type == 4)
                                                {{ __('basic.leads not interested') }}
                                                @elseif ($patient->type == 5)
                                                {{ __('basic.vip_patient') }}
                                                @endif
                                            </p>
                                        </div>
                                    </div>

                                    <div class="row mb-2">
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.gendar') }}
                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold">{{ $patient->gendar }}</p>
                                        </div>
                                        <div class="col">
                                            <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.blood') }}
                                            </h6>
                                            <p class="text-gray-600 text-s fw-bold">{{ $patient->blood_type }}</p>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="col">

            <div class="row h-100">

                <div class="col-6 pe-2">
                    <div class="card h-100 shadow text-white" style="background-color: #FF7777;">
                        <!-- Card Header - Dropdown -->
                        <div
                            class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-transparent border-bottom-0">
                            <h6 class="m-0 fw-bold">Heart Rate</h6>
                            <div class="dropdown no-arrow">
                                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-white"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                    aria-labelledby="dropdownMenuLink">
                                    <a class="dropdown-item" href="#">Action</a>
                                </div>
                            </div>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body d-flex align-self-center align-items-center text-center p-0">
                            <div class="mb-2">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                    aria-hidden="true" role="img" width="5em" height="5em"
                                    preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24">
                                    <path
                                        d="M21 11h-3.94a.78.78 0 0 0-.21 0h-.17a1.3 1.3 0 0 0-.15.1a1.67 1.67 0 0 0-.16.12a1 1 0 0 0-.09.13a1.32 1.32 0 0 0-.12.2l-1.6 4.41l-4.17-11.3a1 1 0 0 0-1.88 0L6.2 11H3a1 1 0 0 0 0 2H7.3a.86.86 0 0 0 .16-.1a1.67 1.67 0 0 0 .16-.12l.09-.13a1 1 0 0 0 .12-.2l1.62-4.53l4.16 11.42a1 1 0 0 0 .94.66a1 1 0 0 0 .94-.66l2.3-6.34H21a1 1 0 0 0 0-2z"
                                        fill="currentColor" />
                                </svg>
                                <h1 class="fw-bold mb-3">
                                    @empty($patient->heart_rate)
                                    <h5 class="fw-light">Not Yet</h5>
                                    @else
                                    {{ $patient->heart_rate }} <small class="text-xs fw-normal">bpm</small>
                                    @endempty
                                </h1>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-6 ps-2">
                    <div class="card h-100 shadow min-height-card text-white" style="background-color: #77BEFF;">
                        <!-- Card Header - Dropdown -->
                        <div
                            class="card-header py-3 d-flex flex-row align-items-center justify-content-between bg-transparent border-bottom-0">
                            <h6 class="m-0 fw-bold">BL Pressure</h6>
                            <div class="dropdown no-arrow">
                                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-white"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                    aria-labelledby="dropdownMenuLink">
                                    <div class="dropdown-header">Dropdown Header:</div>
                                    <a class="dropdown-item" href="#">Action</a>
                                    <a class="dropdown-item" href="#">Another action</a>
                                    <div class="dropdown-divider"></div>
                                    <a class="dropdown-item" href="#">Something else here</a>
                                </div>
                            </div>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body d-flex align-self-center align-items-center text-center p-0">
                            <div class="mb-2">
                                <svg width="5em" height="5em" viewBox="0 0 48 48" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M9 19.0345C9 13.3091 12.8117 8 18.0312 8C21.6533 8 24.341 10.382 26 13.7611C27.6589 10.3822 30.3466 8 33.9688 8C39.1889 8 43 13.31 43 19.0345C43 31.2888 26 40 26 40C26 40 14.5487 34.4872 10.4431 25.4444H20.5848L22.1968 22.5788L24.0797 29.1692L28.4891 23.5H34V21.5H27.5109L24.9203 24.8308L22.8032 17.4212L19.4152 23.4444H9.67984C9.89182 24.1288 10.1486 24.7957 10.4431 25.4444L6 25.4443V23.4443L9.67984 23.4444C9.24643 22.0453 9 20.5731 9 19.0345Z"
                                        fill="#ffffff" />
                                </svg>
                                <h2 class="fw-bold mt-3 mb-3">
                                    @empty($patient->bl_pressure)
                                    <h5 class="fw-light">Not Yet</h5>
                                    @else
                                    {{ $patient->bl_pressure }}
                                    @endempty
                                </h2>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

    @role('Super-admin|Doctor|Branch-manager|Receptionist|Operation|Operation_doctor')
    <!-- Content Row,  -->
    <div class="row">
        <!------ all patient js code ------>
        @include('patient.component.clients.ramad.exm_med')
        @include('patient.component.clients.ramad.treat_sess')
        @include('patient.component.clients.ramad.lab')
    </div>
    @endrole

    <!-- Content Row,  -->
    <div class="row pe-0">
        @include('patient.component.appointment')
        @include('patient.component.payment')
    </div>

</div> <!-- end of container-fluid -->


@endsection


@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<!-- datapicker date and time -->
<script src="https://fastly.jsdelivr.net/npm/flatpickr"></script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>

<script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>


<script type="text/javascript" language="javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/jQuery.print/1.6.2/jQuery.print.min.js">
</script>


<!-- Toastr alert -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
    toastr.options = {
            "closeButton": false,
            "debug": false,
            "newestOnTop": false,
            "progressBar": true,
            "positionClass": "toast-bottom-left",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "1000",
            "timeOut": "5000",
            "extendedTimeOut": "1000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }

        @if (Session::has('success'))
            toastr.success("{{ Session::get('success') }}");
        @endif

        @if (Session::has('errors'))
            toastr.error("{{ session()->get('errors')->first() }}");
        @endif

        @if (Session::has('info'))
            toastr.info("{{ session('info') }}");
        @endif

        @if (Session::has('warning'))
            toastr.warning("{{ session('warning') }}");
        @endif
</script>


<!-- Validator plugin -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>

<script>
    //Rules for the Validator plugin
        var $validator = $('.myform').validate({
            rules: {
                favorite_address: {
                    maxlength: 50,
                },
                name_street: {
                    maxlength: 50,
                },
                address_details: {
                    maxlength: 50,
                },
                building_number: {
                    maxlength: 50,
                },
                apartment_number: {
                    maxlength: 50,
                },
                phone: {
                    maxlength: 50,
                },

            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'permissions':
                        error.insertAfter($("#permissions-js-error-valid"));
                        break;

                    default:
                        error.insertAfter(element);
                }

            },
        });
</script>

<!------ all patient js code ------>
@include('patient.component.patientjs')
@endsection
