<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pat_examination extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'type', //1- body,2-tagmel,3-ramad	
        'calendable_id',
        'calendable_type',
        'patient_id',
        'lid_od',
        'lid_os',
        'surface_od',
        'surface_os',
        'ac_od',
        'ac_os',
        'pupil_od',
        'pupil_os',
        'lens_od',
        'lens_os',
        'iris_od',
        'iris_os',
        'angle_od',
        'angle_os',
        'fundus_od',
        'fundus_os',
        'motility_od',
        'motility_os',
        'iop_od',
        'iop_os',
        'note',
    ];


    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'calendable_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function calendable()
    {
        return $this->morphTo();
    }
}