<?php

namespace App\Models\Invoice;

use App\Models\Branch\Branch;
use App\Models\Patient\Service_inv_cat;
use App\Models\Patient\Specialty_cat;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'invoice_id',
        'type', //1= not paid, 2= installment, 3=paid
        'method', //1- cash, 2-visa or other
        'amount',
        'responsible_worker',
        'paid_date',
        'installment_date',
    ];
    
    public $timestamps = false;

    /*
        -------------- Relationships --------------
     */

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id');
    }

    public function worker()
    {
        return $this->belongsTo(User::class, 'responsible_worker', 'id');
    }
    
    public function items()
    {
        return $this->hasMany(Invoice_item::class, 'invoice_id', 'invoice_id');
    }

    public function getMethodt_nameAtribute()
    {
        if($this->method == 1){
            return "Cash";
        }else{
            return "Visa";
        }
    }
}