<?php

namespace App\Http\Controllers\admins;

use App\Http\Controllers\Controller;
use App\Http\Requests\UsersRequest;
use App\Models\Admin\Attendance;
use App\Models\Admin\Worker_record;
use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Invoice\Invoice;
use App\Models\location\City;
use App\Models\location\Country;
use App\Models\Patient\Specialty_cat;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use Spatie\Permission\Models\Role;

class UsersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //$users = User::select('id', 'name', 'email')->get();

        $users = User::select(['id','first_name', 'second_name', 'avatar', 'started_work', 'deactivate', 'branch_id'])->with(['branch' => function ($q) {
            $q->select('id', 'name');
        }])->get();

        return view('admins.index', compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries = Country::orderByRaw('RAND()')->get();
        $branches = Branch::all();
        $roles = Role::all();
        $speicalty = Specialty_cat::all();

        return view('admins.create', compact('countries', 'branches', 'roles', 'speicalty'));
    }

    //for select input ajax to send the cities beasd on the given country
    public function createcityajax($id)
    {
        return City::where('country_id', $id)->orderBy('fav', 'DESC')->get();
    }
    

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(UsersRequest $request)
    {
        // the valdiation is in (app/requests/UsersRequest)
        
        //insert img
        if($request->hasFile('avatar')){
            $file_extension = request()->avatar->getClientOriginalExtension();
            $file_name = $request->input('first_name') . time() . '.' . $file_extension;
            $path = 'img/useravatar';
            $request->avatar->move($path, $file_name);
        }
        else{
            $file_name = 'default-pp.png';
        }

        $user = User::create([  
            'avatar' => $file_name,
            'first_name' => $request->input('first_name'),
            'second_name' => $request->input('second_name'),
            'specialty_id' => $request->input('specialty_id'),
            'email' => $request->input('email'),
            'password' => bcrypt($request->input('password')),
            'gendar' => $request->input('gendar'),
            'birthday' => $request->input('birthday'),
            'country' => $request->input('country'),
            'city' => $request->input('city'),
            'phone_number' => $request->input('phone_number'),
            'sec_phone_number' => $request->input('sec_phone_number'),
            'branch_id' => $request->input('branch'),
            'started_work' => $request->input('started_work'),
            'note' => $request->input('note'),
        ]);

        //for inserting the role
        foreach($request->input('role') as $item){
            $user->assignRole($item);
        }
        
        session()->flash('success', 'The user has been created');
        return redirect()->route('sett.admin.index');
    }

    //doctor records
    public function create_doctor_record(Request $request){

        $this->validate($request, [
            'doctor_id' => ['required', 'exists:users,id'],
            'start' => ['required', 'date', 'date_format:Y-m-d'],
            'note' => 'max:250',
        ]);

        $worker_record = Worker_record::create([  
            'doctor_id' => $request->input('doctor_id'),
            'type' => $request->input('type'),
            'start' => $request->input('start'),
            'amount' => $request->input('amount'),
            'note' => $request->input('note'),
        ]);

        session()->flash('success', 'The record has been created');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function show($id)
    {
        //
    }


    public function allstatcs(Request $request){

        if(!empty($request->input('specialty'))){
            $specialty = $request->input('specialty');
        }else{
            $specialty = 'all';
        }
        if(!empty($request->input('branch'))){
            $branch = $request->input('branch');
        }else{
            $branch = 'all';
        }
        if(!empty($request->input('from'))){
            $from = $request->input('from');
        }else{
            $from = 'all';
        }
        if(!empty($request->input('to'))){
            $to = $request->input('to');
        }else{
            $to = 'all';
        }

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();
         
       
        // ---------------------- 

        $worker_total = User::select('id');

        if($specialty !== "all"){
            $worker_total = $worker_total->where('specialty_id', $specialty);
        }

        if($branch !== "all"){
            $worker_total = $worker_total->where('branch_id', $branch);
        }

        $worker_total = $worker_total->count();


        // ---------------------- 

        $branch_worker = User::select('branch_id', DB::raw('count(*) as total'))
        ->groupBy('branch_id')
        ->with(['branch' => function ($q) {
            $q->select('id', 'name');}])
        ->limit(11)
        ->orderBy('total', 'DESC');

        if($specialty !== "all"){
            $branch_worker = $branch_worker->where('specialty_id', $specialty);
        }

        $branch_worker = $branch_worker->get();
        
        // ---------------------- 
        
        $creator = Appointment::select('creator_id', DB::raw('count(*) as total'))
        ->groupBy('creator_id')
        ->with(['creator' => function ($q) {
            $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
        ->whereNotNull('creator_id')
        ->whereYear('created_at', date('Y'))
        ->limit(11)
        ->orderBy('total', 'DESC');

        if($specialty !== "all"){
            $creator = $creator->where('specialty_id', $specialty);
        }

        if($branch !== "all"){
            $creator = $creator->where('branch_id', $branch);
        }

        $creator= $creator->get();

        // ---------------------- 

        $creator_month = Appointment::select('creator_id', DB::raw('count(*) as total'))
        ->groupBy('creator_id')
        ->with(['creator' => function ($q) {
            $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
        ->whereNotNull('creator_id')
        ->limit(11)
        ->orderBy('total', 'DESC');

        if($specialty !== "all"){
            $creator_month = $creator_month->where('specialty_id', $specialty);
        }

        if($branch !== "all"){
            $creator_month = $creator_month->where('branch_id', $branch);
        }

        if($from !== "all"){
            $creator_month = $creator_month->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }else{
            $creator_month = $creator_month->whereMonth('created_at', date('m'));
        }
        
        $creator_month = $creator_month->get();
          // ---------------------- 
        
          $confirmation = Appointment::select('last_update_person_id', DB::raw('count(*) as total'))
          ->groupBy('last_update_person_id')
          ->with(['last_update_person' => function ($q) {
              $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
          ->whereNotNull('last_update_person_id')
          ->whereYear('created_at', date('Y'))
          ->limit(11)
          ->orderBy('total', 'DESC');
  
          if($specialty !== "all"){
              $confirmation = $confirmation->where('specialty_id', $specialty);
          }
  
          if($branch !== "all"){
              $confirmation = $confirmation->where('branch_id', $branch);
          }
  
          $confirmation = $confirmation->get();
  
          // ---------------------- 
    
          $confirmation_month = Appointment::select('last_update_person_id', DB::raw('count(*) as total'))
          ->groupBy('last_update_person_id')
          ->with(['last_update_person' => function ($q) {
              $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
          ->whereNotNull('last_update_person_id')
          ->limit(11)
          ->orderBy('total', 'DESC');
  
          if($specialty !== "all"){
              $confirmation_month = $confirmation_month->where('specialty_id', $specialty);
          }
  
          if($branch !== "all"){
              $confirmation_month = $confirmation_month->where('branch_id', $branch);
          }
  
          if($from !== "all"){
              $confirmation_month = $confirmation_month->whereBetween('created_at', [
                  Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                  Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
              ]);
          }else{
              $confirmation_month = $confirmation_month->whereMonth('created_at', date('m'));
          }
          
          $confirmation_month = $confirmation_month->get();

        //----------

        $doctor = Appointment::select('doctor_id', DB::raw('count(*) as total'))
        ->groupBy('doctor_id')
        ->with(['doctor' => function ($q) {
            $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
        ->whereNotNull('doctor_id')
        ->whereYear('created_at', date('Y'))
        ->limit(11)
        ->orderBy('total', 'DESC');

        if($specialty !== "all"){
            $doctor = $doctor->where('specialty_id', $specialty);
        }

        if($branch !== "all"){
            $doctor = $doctor->where('branch_id', $branch);
        }
        
        $doctor = $doctor->get();

        // ---------------------- 

        $doctor_month = Appointment::select('doctor_id', DB::raw('count(*) as total'))
        ->groupBy('doctor_id')
        ->with(['doctor' => function ($q) {
            $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
        ->whereNotNull('doctor_id')
        ->whereMonth('created_at', date('m'))
        ->limit(11)
        ->orderBy('total', 'DESC');
        
        if($specialty !== "all"){
            $doctor_month = $doctor_month->where('specialty_id', $specialty);
        }

        if($branch !== "all"){
            $doctor_month = $doctor_month->where('branch_id', $branch);
        }

        if($from !== "all"){
            $doctor_month = $doctor_month->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        }else{
            $doctor_month = $doctor_month->whereMonth('created_at', date('m'));
        }
        
        $doctor_month = $doctor_month->get();

        // ---------------------- 


        $accountant = Invoice::select('invoices.id', 'payments.amount', DB::raw('sum(payments.amount) as sums'))
        ->join('payments', 'invoices.id', '=', 'payments.invoice_id')
        ->where('invoices.type', 0)
        ->where('invoices.status', '!=' , 0)
        ->where('invoices.operation', 0)
        ->where('payments.type', 3)
        ->groupBy('payments.responsible_worker');
        

        if($specialty !== "all"){
            $accountant = $accountant->where('invoices.specialty_id', $specialty); 
        }

        if(Auth::user()->branch_id == 0){
            if($branch !== "all"){
                $accountant = $accountant->where('invoices.branch_id', $branch); 
            }
        }else{
            $accountant = $accountant->where('invoices.branch_id', Auth::user()->branch_id);
        }

        if($from !== "all"){
            $accountant = $accountant->whereYear('payments.paid_date', $from)
            ->with(['payment' => function ($q) use ($from){
                $q->select('id','invoice_id','type', 'method', 'amount', 'responsible_worker', 'paid_date')
                ->with(['worker' => function ($q) {
                    $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
            ;}]);
        }else{
            $accountant = $accountant->whereYear('payments.paid_date', date('Y'))
            ->with(['payment' => function ($q) use ($from){
                $q->select('id','invoice_id','type', 'method', 'amount', 'responsible_worker', 'paid_date')
                ->with(['worker' => function ($q) {
                    $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
            ;}]);
        }
        
        $accountant = $accountant->get();

        // ---------------------- 

        $accountant_month = Invoice::select('invoices.id', 'payments.amount', DB::raw('sum(payments.amount) as sums'))
        ->join('payments', 'invoices.id', '=', 'payments.invoice_id')
        ->where('invoices.type', 0)
        ->where('invoices.status', '!=' , 0)
        ->where('invoices.operation', 0)
        ->where('payments.type', 3)
        ->groupBy('payments.responsible_worker');
        

        if($specialty !== "all"){
            $accountant_month = $accountant_month->where('invoices.specialty_id', $specialty); 
        }

        if(Auth::user()->branch_id == 0){
            if($branch !== "all"){
                $accountant_month = $accountant_month->where('invoices.branch_id', $branch); 
            }
        }else{
            $accountant_month = $accountant_month->where('invoices.branch_id', Auth::user()->branch_id);
        }

        if($from !== "all"){
            $accountant_month = $accountant_month->whereMonth('payments.paid_date', $from)
            ->with(['payment' => function ($q) use ($from){
                $q->select('id','invoice_id','type', 'method', 'amount', 'responsible_worker', 'paid_date')
                ->with(['worker' => function ($q) {
                    $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
            ;}]);
        }else{
            $accountant_month = $accountant_month->whereMonth('payments.paid_date', date('m'))
            ->with(['payment' => function ($q) use ($from){
                $q->select('id','invoice_id','type', 'method', 'amount', 'responsible_worker', 'paid_date')
                ->with(['worker' => function ($q) {
                    $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));}])
            ;}]);
        }
        
        $accountant_month = $accountant_month->get();
        // ---------------------- 

        return view('admins/allstatcs', compact('worker_total' ,'branch_worker', 'specialty_cat', 'specialty', 'branches', 'branch', 'creator', 'doctor', 'creator_month', 'doctor_month', 'confirmation', 'confirmation_month','accountant','accountant_month', 'from', 'to'));

    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function edit($id)
    {
        $user = User::with(['cityuser' => function ($q) {$q->select('id', 'name');}])->find($id);

        $speicalty = Specialty_cat::all();

        $roles = Role::select('id','name')->get();
        $userRole = $user->roles->pluck('id')->all();
        $countries = Country::orderByRaw('RAND()')->get();
        $branches = Branch::all();
        
        return view('admins.edit',compact('user', 'speicalty','roles','userRole', 'countries', 'branches'));
    }


    public function edit_profile_user()
    {
        $user_id = Auth::id();
        $user = User::with(['cityuser' => function ($q) {$q->select('id', 'name');}])->find($user_id);

        $countries = Country::orderByRaw('RAND()')->get();
        $branches = Branch::all();
        
        return view('admins.edit_profile',compact('user', 'countries'));
    }


    public function edit_profile_user_store(UsersRequest $request)
    {
        $user_id = Auth::id();
        $user = User::find($user_id);

        $user->first_name = $request->input('first_name');
        $user->second_name = $request->input('second_name');
        $user->gendar = $request->input('gendar');
        $user->birthday = $request->input('birthday');
        $user->country = $request->input('country');
        $user->city = $request->input('city');
        $user->phone_number = $request->input('phone_number');
        $user->sec_phone_number = $request->input('sec_phone_number');
        $user->started_work = $request->input('started_work');
        $user->note = $request->input('note');

        if(!empty($request->input('newpassword'))){
            $user->password = bcrypt($request->input('newpassword'));
        }

        //insert img
        if($request->hasFile('avatar')){

            if($user->avatar !== "default-pp.png"){
                //to remove the old avatar and also keep the default img
                $imagePath = public_path('img/useravatar/'.$user->avatar);
                if(File::exists($imagePath)){
                    File::delete($imagePath);
                }
            }
            
            $file_extension = request()->avatar->getClientOriginalExtension();
            $file_name = $request->input('first_name') . time() . '.' . $file_extension;
            $path = 'img/useravatar';
            $request->avatar->move($path, $file_name);

            $user->avatar = $file_name; //new img file name
        }
        else{
            $file_name = request()->avatar;
        }

        $user->save();

        session()->flash('success', 'The user has been updated');
        return redirect()->back();
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(UsersRequest $request, $id)
    {
        $user = User::find($id);

        $user->first_name = $request->input('first_name');
        $user->second_name = $request->input('second_name');
        $user->specialty_id = $request->input('specialty_id');
        $user->email = $request->input('email');
        $user->gendar = $request->input('gendar');
        $user->birthday = $request->input('birthday');
        $user->country = $request->input('country');
        $user->city = $request->input('city');
        $user->phone_number = $request->input('phone_number');
        $user->sec_phone_number = $request->input('sec_phone_number');
        $user->branch_id = $request->input('branch');
        $user->started_work = $request->input('started_work');
        $user->deactivate = $request->input('deactivate');
        $user->note = $request->input('note');

        if(!empty($request->input('newpassword'))){
            $user->password = bcrypt($request->input('newpassword'));
        }

        //insert img
        if($request->hasFile('avatar')){

            if($user->avatar !== "default-pp.png"){
                //to remove the old avatar and also keep the default img
                $imagePath = public_path('img/useravatar/'.$user->avatar);
                if(File::exists($imagePath)){
                    File::delete($imagePath);
                }
            }
            
            $file_extension = request()->avatar->getClientOriginalExtension();
            $file_name = $request->input('first_name') . time() . '.' . $file_extension;
            $path = 'img/useravatar';
            $request->avatar->move($path, $file_name);

            $user->avatar = $file_name; //new img file name
        }
        else{
            $file_name = request()->avatar;
        }

        $user->save();


        //for inserting the role
        $user->roles()->detach();
        foreach($request->input('role') as $item){
            $user->assignRole($item);
        }
        
        session()->flash('success', 'The user has been updated');
        return redirect()->route('sett.admin.index');
    }


    public function note_ajax(Request $request){

        $id = Auth::id();
        
        $user = User::find($id);
        $user->note = $request->input('query');

        $user->save();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        User::find($request->user_id)->delete();
               
        session()->flash('success', 'The user has been deleted');
        return redirect()->route('sett.admin.index');
    }

    //------------


    public function attendance($worker_id, $date = null){

        if($date){  
            $month_year_explode = explode('-',$date);
            $year = $month_year_explode[1];
            $month = $month_year_explode[0];
        }else{
            $year = date('Y');
            $month = date('m');
        }
        
        $atten = Attendance::where('worker_id', $worker_id)
        ->whereYear('arrived_time', $year)
        ->whereMonth('arrived_time', $month)
        ->with(['branch' => function ($q) {
            $q->select('id', 'name');}])
        ->orderBy('arrived_time', 'ASC')
        ->get();

        $branches = Branch::select('id','name')->get();

        $fixed_working_hours = prox_sett('workinghours');

        return view('admins/attendance', compact('worker_id', 'atten', 'branches', 'fixed_working_hours'));
    }


    public function create_attendance_admin(Request $request){
        
        $branches = Branch::select('id','name')->get();

        return view('admins/create_attendance_admin', compact('branches'));
    }


    public function insert_attendance_admin(Request $request){

        $this->validate($request, [
            'doctor_id' => 'required|exists:users,id',
            'branch_id' => 'required|exists:branches,id',
            'arrived_time' => 'required|date',
            'leave_time' => 'required',
        ]);

        $arrived_time_for_time = date('Y-m-d', strtotime($request->input('arrived_time')));

        $leave_time_after = $arrived_time_for_time . ' ' . $request->input('leave_time');
        
        $atten = Attendance::where('worker_id', $request->input('doctor_id'))
        ->whereDate('arrived_time', $arrived_time_for_time)
        ->first();

        if(!$atten){
            $attendence = Attendance::create([  
                'worker_id' =>  $request->input('doctor_id'),
                'branch_id' =>  $request->input('branch_id'),
                'arrived_time' =>  $request->input('arrived_time'),
                'leave_time' =>  $leave_time_after,
            ]);

            return redirect()->route('sett.admin.index')
                ->with('success', 'Attendence has been created successfully');
        }else{
            return redirect()->route('sett.admin.index')
            ->with('error_delete', 'Attendence has been created before in this day');
        }

    }


    public function edit_attendance(Request $request, $id){
        
        $atten = Attendance::find($id);

        $branches = Branch::select('id','name')->get();

        return view('admins/edit_attendance', compact('atten','branches'));
    }


    public function edit_attendance_insert(Request $request, $id){
        
        $atten = Attendance::find($id);

        $atten->branch_id = $request->input('branch_id');
        $atten->arrived_time = $request->input('arrived_time');
        $atten->leave_time = $request->input('leave_time');
        $atten->save();

        $branches = Branch::select('id','name')->get();


        session()->flash('success', 'The user has been updated');
        return redirect()->route('sett.hr_attendance', $atten->worker_id);
    }

    public function my_attendance($date = null){

        if($date){  
            $month_year_explode = explode('-',$date);
            $year = $month_year_explode[1];
            $month = $month_year_explode[0];
        }else{
            $year = date('Y');
            $month = date('m');
        }
        
        $worker_id = auth::id();

        $atten = Attendance::where('worker_id', $worker_id)
        ->whereYear('arrived_time', $year)
        ->whereMonth('arrived_time', $month)
        ->with(['branch' => function ($q) {
            $q->select('id', 'name');}])
        ->get();

        $branches = Branch::select('id','name')->get();

        $fixed_working_hours = prox_sett('workinghours');

        return view('admins/my_attendance', compact('atten' ,'branches', 'fixed_working_hours'));
    }

    public function worker_attendance(Request $request){
        
        $worker_id = auth::id();

        $atten = Attendance::where('worker_id', $worker_id)
        ->whereDate('arrived_time', Carbon::today())
        ->first();

        $branches = Branch::select('id','name')->get();

        return view('admins/worker_attendance', compact('atten','branches'));
    }

    //doctor records
    public function worker_attendance_insert(Request $request){

        $this->validate($request, [
            //'doctor_id' => ['required', 'exists:users,id'],
            //'start' => ['required', 'date', 'date_format:Y-m-d'],
            //'note' => 'max:250',
        ]);

        $worker_id = auth::id();
        
        //get the client IP
        $worker_ip = $request->ip();

        if(Auth::user()->branch_id == 0){
            $branch = Branch::select('id','latitude', 'longitude')->where('id', $request->input('branch_id'))->first();
            $branch_id = $branch->id;
            $branch_lat = $branch->latitude;
            $branch_long = $branch->longitude;
        }else{
            $branch_id = Auth::user()->branch_id;
            $branch_lat = Auth::user()->branch->latitude;
            $branch_long = Auth::user()->branch->longitude;
        }
        
        $lati = $request->input('lati');
        $long = $request->input('long');
        $meters = 200;
        

        $atten = Attendance::where('worker_id', $worker_id)
        ->whereDate('arrived_time', Carbon::today())
        ->first();

        //to insert leave time
        if($atten){
            if(!$atten->leave_time){

                $check_ip = Attendance::where('worker_ip', $worker_ip)
                ->whereDate('leave_time', Carbon::today())
                ->first();

                //check if the ip exsit in recoreds for today
                if($check_ip){
                    session()->flash('error_delete', 'Your IP has been detected for today');
                }else{

                    //check the distance
                    //distance in meters
                    $distance = $this->circleDistance($lati, $long, $branch_lat, $branch_long);
                    $str_arr = explode('.',$distance);
                    $distance_amount = $str_arr[0];

                    if($distance_amount < $meters){

                        $atten->leave_time = Carbon::now();
                        $atten->save();

                        session()->flash('success', 'You have left for today successfully');
                    }else{
                        session()->flash('error_delete', 'You are far from the clinic, please be closer');
                    }
                }

            }else{
                session()->flash('error_delete', 'You have already left');
            }

        //to create arrvice time
        }else{

            $check_ip = Attendance::where('worker_ip', $worker_ip)
            ->whereDate('arrived_time', Carbon::today())
            ->first();

            //check if the ip exsit in recoreds for today
            if($check_ip){
                session()->flash('error_delete', 'Your IP has been detected for today');
            }else{

                //check the distance
                //distance in meters
                $distance = $this->circleDistance($lati, $long, $branch_lat, $branch_long);
                $str_arr = explode('.',$distance);
                $distance_amount = $str_arr[0];

                if($distance_amount < $meters){
                    $attendence = Attendance::create([  
                        'worker_id' => $worker_id,
                        'branch_id' => $branch_id,
                        'arrived_time' => Carbon::now(),
                        'worker_ip' => $worker_ip,
                    ]);
                    session()->flash('success', 'You have attended for today successfully');
                }else{
                    session()->flash('error_delete', 'You are far from the clinic, please be closer');
                }
            }
        }

    }

    public function circleDistance(
        $latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
      {
        // convert from degrees to radians
        $latFrom = deg2rad($latitudeFrom);
        $lonFrom = deg2rad($longitudeFrom);
        $latTo = deg2rad($latitudeTo);
        $lonTo = deg2rad($longitudeTo);
      
        $lonDelta = $lonTo - $lonFrom;
        $a = pow(cos($latTo) * sin($lonDelta), 2) +
          pow(cos($latFrom) * sin($latTo) - sin($latFrom) * cos($latTo) * cos($lonDelta), 2);
        $b = sin($latFrom) * sin($latTo) + cos($latFrom) * cos($latTo) * cos($lonDelta);
      
        $angle = atan2(sqrt($a), $b);
        return $angle * $earthRadius;
      }

      public function get_user_location_info(){
        $user_ip = getenv('REMOTE_ADDR');
        $geo = unserialize(file_get_contents("http://www.geoplugin.net/php.gp?ip=$user_ip"));
        $country = $geo["geoplugin_countryName"];
        $city = $geo["geoplugin_city"];
      }
  

}