<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Patient\Pulse;

class UpdatePulses extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'patient:update_pulses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update Pulses from one-many  to many-many';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $pulses = Pulse::all();
        foreach ($pulses as $pulse) {
            $pulse->pulse_area()->attach($pulse->pulse_area_id);
        }
    }
}
