

<?php if(count($invoice) > 0): ?>
<?php if($worker_type === "doctor"): ?>
<?php
$worker_type = $invoice[0]->doctor->name;
?>
<?php elseif($worker_type === "worker"): ?>
<?php
$worker_type = $invoice[0]->invoice->name;
?>
<?php else: ?>
<?php
$worker_type = "";
?>
<?php endif; ?>
<?php endif; ?>

<?php $__env->startSection('title', 'Search Invoice | Proxima - Medical Management app ' . $worker_type); ?>

<?php $__env->startSection('title-topbar', 'Search ' . $worker_type); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>
<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">
<link rel="stylesheet"
    href="https://nightly.datatables.net/fixedheader/css/fixedHeader.dataTables.css?_=f0de745b101295e88f1504c17177ff49.css"
    type="text/css" />
<?php $__env->stopSection(); ?>

<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">

        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.invo_other_search')); ?>">Invoice Search
                | </a>
            <a class="text-gray-300">Day invoices</a>
        </span>

    </div>

    <div class="row mb-2">
        <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center border-bottom-0 pe-0" id="myTab"
            role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="year_invoice-tab" data-bs-toggle="tab"
                    data-bs-target="#year_invoice" type="button" role="tab" aria-controls="year_invoice"
                    aria-selected="true" class="text-gray-500"><i class="fas fa-money-check me-1"></i>
                    Details</button>
            </li>
        </ul>
    </div>

    <div class="tab-content" id="myTabContent">

        <div class="tab-pane fade show active" id="year_invoice" role="tabpanel" aria-labelledby="year_invoice">

            <div class="row">
                <div class="col-12 px-0 px-md-2 mb-4">
                    <div class="card card-input shadow h-100">
                        <!-- Card Header - Dropdown -->
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> Income invoices</h6>
                        </div>

                        <!-- Card Body -->
                        <div class="card-body overflow-scroll">

                            <div class="table-responsive">
                                <table class="table display datatable-modal" id="table-income-all" width="100%"
                                    cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="text-xs text-center">Status</th>
                                            <th class="text-xs text-center fw-bold">Total</th>
                                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Accountant')): ?>
                                            <th class="text-xs text-center fw-bold">Cost</th>
                                            <?php endif; ?>
                                            <th class="text-xs text-center">Item Price</th>
                                            <th class="text-xs text-center">Items</th>
                                            <th class="text-xs text-center">Description</th>
                                            <th class="text-xs text-center">Discount</th>
                                            <th class="text-xs text-center">Patient</th>
                                            <th class="text-xs text-center">Doctor</th>
                                            <th class="text-xs text-center">Branch</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php
                                        $total_income_cash = 0;
                                        $total_income_visa = 0;
                                        $total_item_price = 0;
                                        ?>

                                        <?php $__currentLoopData = $invoice; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-truncate">
                                                <?php if($item->invoice->status == 0): ?>
                                                <?php
                                                $status = 'cancel-color-btn';
                                                $status_msg = __('basic.not paid');
                                                ?>
                                                <?php elseif($item->invoice->status == 1): ?>
                                                <?php
                                                $status = 'pend-color-btn';
                                                $status_msg = __('basic.pending');
                                                ?>
                                                <?php elseif($item->invoice->status == 2): ?>
                                                <?php
                                                $status = 'prog-color-btn';
                                                $status_msg = __('basic.installment');
                                                ?>
                                                <?php elseif($item->invoice->status == 3): ?>
                                                <?php
                                                $status = 'done-color-btn';
                                                $status_msg = __('basic.paid');
                                                ?>
                                                <?php elseif($item->invoice->status == 4): ?>
                                                <?php
                                                $status = 'cancel-color-btn';
                                                $status_msg = __('basic.refund');
                                                ?>
                                                <?php endif; ?>
                                                <div
                                                    class="badge px-3 text-xxxs rounded-pill <?php echo e($status); ?> badge-padd-l">
                                                    <?php echo e($status_msg); ?></div>
                                            </td>
                                            <td class="text-center fw-bold text-gray-800">
                                                <?php $__currentLoopData = $item->payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($item_p->method == 1): ?>
                                                <?php
                                                $payment_method_txt = __('basic.cash');
                                                $total_income_cash += $item_p->amount;
                                                ?>
                                                <?php elseif($item_p->method == 2): ?>
                                                <?php
                                                $payment_method_txt = __('basic.visa');
                                                $total_income_visa += $item_p->amount;
                                                ?>
                                                <?php endif; ?>

                                                <?php echo e($item_p->amount); ?> <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs">
                                                    via <?php echo e($payment_method_txt); ?> | shift:
                                                    <?php echo e($item_p->worker->name); ?>

                                                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Accountant')): ?>
                                            <td class="text-truncate"><?php echo e($item->invoice->total_cost); ?> <small
                                                    class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small></td>
                                            <?php endif; ?>
                                            <td class="text-truncate text-center">
                                                <?php
                                                $total_item_price += $item->price;
                                                ?>
                                                <?php echo e($item->price); ?></td>
                                            <td class="text-truncate">
                                                <a href="<?php echo e(route('sett.invoice.show', $item->invoice->id)); ?>"
                                                    class="link-cust-text text-gray-400">
                                                    <?php echo e($item->categorizable->name); ?>

                                                </a>
                                            </td>
                                            <td class="text-truncate"><?php echo e($item->invoice->note); ?></td>
                                            <td class="text-center text-gray-800">
                                                <?php if($item->invoice->discount): ?>
                                                <?php echo e($item->invoice->discount); ?> <small class="text-gray-300 text-xxxs">
                                                    EGP
                                                </small>
                                                <div class="text-gray-300 text-xxxs">
                                                    on <?php echo e($item->invoice->items_price); ?> egp
                                                </div>
                                                <?php else: ?>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-truncate">
                                                <?php if($item->invoice->receivable): ?>
                                                <?php echo e($item->invoice->receivable->name); ?>

                                                <?php else: ?>
                                                <?php echo e(__('patientappo.no receiver')); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-truncate">
                                                <?php if($item->doctor): ?>
                                                <?php echo e($item->doctor->name); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="text-truncate"><?php echo e($item->invoice->branch->name); ?>

                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>


                                    <tfoot>
                                        <tr>
                                            <th class="text-center fw-bold text-s" style="background-color: #e2edfd;">
                                                Paid</th>
                                            <th class="text-center fw-bold text-s2" style="background-color: #e2edfd;">
                                                <?php echo e($total_income = $total_income_cash + $total_income_visa); ?> <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            <th class="text-center fw-bold text-s">Cash</th>
                                            <th class="text-center fw-bold text-s2">
                                                <?php echo e($total_income_cash); ?> <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            <th class="text-center fw-bold text-s">Credit</th>
                                            <th class="text-center fw-bold text-s2">
                                                <?php echo e($total_income_visa); ?> <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            </th>

                                            <th class="text-center fw-bold text-s">Items Price</th>
                                            <th class="text-center fw-bold text-s2">
                                                <?php echo e($total_item_price); ?> <small
                                                    class="text-gray-300 text-xxxs">EGP</small>
                                            </th>
                                        </tr>
                                    </tfoot>

                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>

    <div class="row">

        <div class="col-12 px-0 px-md-2">
            <div class="card card-input shadow mb-4">
                <!-- Card Body -->
                <div class="card-body">
                    <div class="row">

                        <div class="col-12 col-md-6 mb-3 mb-md-0 border-flex">
                            <div class="mt-4 text-center small">
                                <span class="me-2">
                                    <i class="fas fa-circle text-success"></i> Income
                                </span>
                                <span class="me-2">
                                    <i class="fas fa-circle text-primary"></i> Expenses
                                </span>
                            </div>
                            <div class="chart-pie pt-4 pb-2">
                                <canvas id="myChart">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>

                        <div class="col-12 col-md-6 text-center align-self-center">
                            <h6 class="text-gray-400">Paid</h6>
                            <?php
                            $profit = $total_income;
                            ?>
                            <span class="fs-1"><?php echo e($profit); ?><small class="text-gray-300 text-xxxs">
                                    EGP</small></span>
                            <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Super-admin|Accountant')): ?>
                            <hr>
                            <h6 class="text-gray-400">Items Price</h6>
                            <span class="fs-1"><?php echo e($total_item_price); ?><small class="text-gray-300 text-xxxs">
                                    EGP</small></span>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>

    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
                $('.js-example-basic-single').select2();
                //hide search
                $('.select2-no-search').select2({
                    minimumResultsForSearch: -1
                });
            });
    </script>

    <script>
        $(document).ready(function() {

                //--------------------- selectors -------------------
                $(document).on('change', '#select-specialty-calendar, #select-branch-calendar', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-specialty-calendar').val();
                    var date2 = $('#select-branch-calendar').val();

                    var url = "<?php echo e(route('sett.invo_day_search', [':date_input', ':date', ':date2'])); ?>";

                    url = url.replace(':date_input', date_input).replace(':date', date).replace(':date2',
                        date2);

                    var url = url;
                    window.location.href = url;
                });
                $(document).on('change', '#calendar-date-input', function() {
                    var date_input = $('#calendar-date-input').val();
                    var date = $('#select-specialty-calendar').val();
                    var date2 = $('#select-branch-calendar').val();

                    var url = "<?php echo e(route('sett.invo_day_search', [':date_input', ':date', ':date2'])); ?>";

                    url = url.replace(':date_input', date_input).replace(':date', date).replace(':date2',
                        date2);

                    window.location.href = url;
                });
            });
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>

    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "yyyy-mm-dd",
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>

    <?php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2', '#dc3545', '#51b24b', '#a94bb2', '#4b8bb2', '#57b24b', '#a5b24b', '#b2804b', '#b24b4b',
    '#834bb2', '#b24b6a', '#574bb2', '#236368', '#232c68', '#682345', '#4b2368', '#234b68', '#306823', '#a39f39',
    '#a239a3', '#a33963', '#a33951', '#a33939', '#c73737', '#6837c7'];
    ?>

    <script>
        // Pie Chart Example
            var ctx = document.getElementById("myChart");
            var myPieChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: ["Income", "Expenses"],
                    datasets: [{
                        data: [<?php echo e($total_income); ?>                        ],
                        backgroundColor: ['#1cc88a', '#4e73df'],
                        hoverBackgroundColor: ['#17a673', '#2e59d9'],
                        hoverBorderColor: "rgba(234, 236, 244, 1)",
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>
    <script
        src="https://nightly.datatables.net/fixedheader/js/dataTables.fixedHeader.js?_=f0de745b101295e88f1504c17177ff49">
    </script>

    <script>
        $(document).ready(function() {

                var table = $('#table-income-all').DataTable({
                        lengthChange: false,
                        "pageLength": 10,
                        "order": [
                            [0, "ASC"]
                        ],
                        buttons: {
                            dom: {
                                button: {
                                    className: 'btn btn-table-export me-0' //Primary class for all buttons
                                }
                            },
                            buttons: [{
                                    extend: 'copyHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'excelHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'pdfHtml5',
                                    footer: true
                                },
                                {
                                    extend: 'print',
                                    footer: true
                                }
                            ]
                        }
                    }

                );
                table.buttons().container()
                    .appendTo('#table-income-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-all_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals-cat').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals-cat_wrapper .col-md-6:eq(0)');

                var table = $('#table-income-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-income-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-expenses-totals').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-expenses-totals_wrapper .col-md-6:eq(0)');

                var table = $('#table-operation-income-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-income-all_wrapper .col-md-6:eq(0)');
                var table = $('#table-operation-expenses-all').DataTable({
                    lengthChange: false,
                    "pageLength": 10,
                    "order": [
                        [0, "ASC"]
                    ],
                    buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        },
                        buttons: [{
                                extend: 'copyHtml5',
                                footer: true
                            },
                            {
                                extend: 'excelHtml5',
                                footer: true
                            },
                            {
                                extend: 'pdfHtml5',
                                footer: true
                            },
                            {
                                extend: 'print',
                                footer: true
                            }
                        ]
                    }
                });
                table.buttons().container()
                    .appendTo('#table-operation-expenses-all_wrapper .col-md-6:eq(0)');

            });
    </script>

    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digiflydev/public_html/dev.mdex/resources/views/invoice/other_search/show.blade.php ENDPATH**/ ?>