<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ $patient->first_name }} Prescription</title>
    <link rel="stylesheet" href="{{ public_path('css/kv-mpdf-bootstrap.css') }}">

</head>

<body>

    <!-- Patient Info -->
    <div class="card-body px-4">

        <div class="row mb-1 b-r-s-cont border2 py-3 px-2">

            <div class="col-xs-6 text-truncate p-0" style="">
                <div class="w-10">
                    <div class="p-0" style="width: 25%;float: left;">
                        <div class="rounded-circle avatar-m2 profile_img"
                            style="background-image: url({{ public_path('img/useravatar/' . $patient->avatar) }})">
                        </div>
                    </div>

                    <div class="text-truncate p-0" style="width: 75%;float: left;">
                        <p class="m-0 p-0 text-s fw-bold2 text-truncate">
                            {{ $patient->first_name . ' ' . $patient->second_name }}</p>
                        <p class="m-0 p-0 text-xs">AFN <span class="fw-bold2">{{ $patient->new_id }}</span></p>
                        <p class="m-0 p-0 text-xs">BFN <span class="fw-bold2">{{ $patient->new_branch_id }}</span></p>
                    </div>
                </div>
            </div>

            <div class="col-xs-2">
                <p class="text-s mb-0">Date</p>
                @if (count($patient->prescriptions) > 0)
                <p class="fw-bold2">{{ $patient->prescriptions[0]->date }}</p>
                @endif
            </div>
            <div class="col-xs-2 text-right">
                <img src="data:image/png;base64,{{ DNS2D::getBarcodePNG($booking_url,'QRCODE') }}" height="70"
                    width="70" /><br />
                <p class="m-0 p-0 text-xxs text-right">النسخة الالكترونية</p>
            </div>
        </div>

        <!-- Medicenes -->
        <div class="row mb-3 px-0 mx-0">
            <div class="col-xs-12 px-0">
                <h4 class="fw-bold2">R /</h4>
                <div class="table-responsive">
                    <table class="table-responsive text-s1 w-100">
                        <thead>
                            {{-- <tr>
                                <th>اسم الدواء</th>
                                <th>التفاصيل</th>
                            </tr> --}}
                        </thead>

                        <tbody>
                            @if (count($patient->prescriptions) > 0)

                            @foreach ($patient->prescriptions[0]->medicines as $item)
                            <tr style="word-wrap: break-word;" class="pb-2">
                                <td class="fw-bold2 pb-2">
                                    - {{ $item->medicinescats->name }}
                                </td>
                                <td class="fw-bold2 text-right" style="direction: rtl">
                                    @if($item->qty > 1)
                                    <span>
                                        {{ $item->qty }}
                                    </span>
                                    @endif

                                    <span>
                                        {{ $item->medicine_type->name }}
                                    </span>
                                    <span>
                                        {{ $item->dose->name }}
                                    </span>
                                    @if($item->med_duration_id > 1)
                                    <span> لمدة </span>
                                    <span>
                                        {{ $item->duration->name }}
                                    </span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach

                            @endif
                        </tbody>

                    </table>
                </div>
            </div>
        </div>


        @if (count($patient->prescriptions) > 0)

        @if($patient->prescriptions[0]->appointment)
        @if($patient->prescriptions[0]->appointment->doctor)
        <h4 class="text-s">Responsible Doctor: {{ $patient->prescriptions[0]->appointment->doctor->first_name }}</h4>
        @endif
        @endif

        @endif
    </div>


</body>

</html>