<?php

namespace App\Models\Patient;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lead_pat_note extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'worker_id',
        'patient_id',
        'note',
        'status', //1= Interested 2= not interested
        'date',
    ];
    
    public $timestamps = false;

    public function worker()
    {
        return $this->belongsTo(User::class, 'worker_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }
   
}