<?php

namespace App\Models\Invoice;

use App\Models\Branch\Branch;
use App\Models\Branch\Inventory\Inventory_item;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service_material extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'service_item_id', 
        'inventory_id',
        'qty',
    ];

    public $timestamps = false;

    public function service()
    {
        return $this->belongsTo(Service_item::class, 'service_item_id', 'id');
    }

    public function inventory()
    {
        return $this->belongsTo(Inventory_item::class, 'inventory_id', 'id');
    }

}