<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Invoice\Expenses_item;
use App\Models\Patient\Service_inv_cat as PatientService_inv_cat;
use App\Models\Patient\Service_item;
use Illuminate\Http\Request;

class Service_inv_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $service = PatientService_inv_cat::all();
        return view('cats/service_inv_cat.index', compact('service'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/service_inv_cat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:service_inv_cats,name',
        ]);

        $service = PatientService_inv_cat::create([
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.service_inv_cat.index')
            ->with('success', 'The item has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service = PatientService_inv_cat::find($id);
        return view('cats/service_inv_cat.edit', compact('service'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $service = PatientService_inv_cat::find($id);
        $service->name = $request->input('name');
        $service->save();

        return redirect()->route('sett.service_inv_cat.index')
            ->with('success', 'Item has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {

        $status = Service_item::where('service_inv_cat_id', $request->input('id_delete'))
            ->where('deactivate', 0)
            ->first();

        $status2 = Expenses_item::where('service_inv_cat_id', $request->input('id_delete'))
            ->first();

        if (empty($status) && empty($status2)) {
            PatientService_inv_cat::find($request->input('id_delete'))->delete();
            session()->flash('success', 'The item has been deleted');
            return redirect()->route('sett.service_inv_cat.index');
        } else {
            session()->flash('error_delete', 'The item has been used before');
            return redirect()->route('sett.service_inv_cat.index');
        }
    }
}
