<?php

namespace App\Http\Controllers\Branch\Inventory;

use App\Http\Controllers\Controller;
use App\Models\Branch\Branch;
use App\Models\Branch\Inventory\Inventory_item as InventoryInventory_item;
use App\Models\Invoice\Invoice_item;
use App\Models\Invoice\Service_cost_material;
use App\Models\Patient\Service_inv_cat;
use App\Models\Patient\Specialty_cat;
use Illuminate\Http\Request;

class Inventory_item extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $inventory = InventoryInventory_item::with(['specialty' => function ($q) {
            $q->select('id', 'name');}])
            ->with(['service_inv_cat' => function ($q) {
                $q->select('id', 'name');}])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');}])
        ->get();
        return view('inventory/cat.index', compact('inventory'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $specialty = Specialty_cat::all();
        $service = Service_inv_cat::all();
        $branch = Branch::all();
        return view('inventory/cat.create', compact('specialty', 'service', 'branch'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'service_inv_cat' => 'required|exists:service_inv_cats,id',
            'specialty_id' => 'required|exists:specialty_cats,id',
            'branch_id' => 'required|exists:branches,id',
            'name' => 'required|unique:service_inv_cats,name',
            'price' => 'required|numeric',
            'place' => 'required',
            'quantity_notify' => 'required|numeric',
        ]);
        
        $inventory = InventoryInventory_item::create([
            'code' => "IV" . $this->generateRandomString(6),
            'service_inv_cat_id' => $request->input('service_inv_cat'),
            'specialty_id' => $request->input('specialty_id'),
            'branch_id' => $request->input('branch_id'),
            'name' => $request->input('name'),
            'price' => $request->input('price'),
            'place' => $request->input('place'),
            'quantity_notify' => $request->input('quantity_notify'),
        ]);

        return redirect()->route('sett.inventory_item.index')
            ->with('success', 'Inventory has been created successfully');
    }

    public function generateRandomString($length = 20) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $inventory = InventoryInventory_item::find($id);
        $specialty = Specialty_cat::all();
        $service_inv_cat = Service_inv_cat::all();
        $branch = Branch::all();

        return view('inventory/cat.edit', compact('inventory', 'specialty', 'service_inv_cat', 'branch'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|unique:service_inv_cats,name',
            'price' => 'required|numeric',
            'place' => 'required',
            'quantity_notify' => 'required|numeric',
        ]);

        $inventory = InventoryInventory_item::find($id);
        $inventory->name = $request->input('name');
        $inventory->price = $request->input('price');
        $inventory->place = $request->input('place');
        $inventory->quantity_notify = $request->input('quantity_notify');
        $inventory->save();

        return redirect()->route('sett.inventory_item.index')
            ->with('success', 'Inventory has updated successfully');     
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        $status = Invoice_item::where('categorizable_type', 'App\Models\Branch\Inventory\Inventory_cat')
        ->where('categorizable_id', $request->input('id_delete'))
        ->first();

        $status2 = Service_cost_material::where('inventory_id', $request->input('id_delete'))
        ->first();

        if(empty($status) && empty($status2)){
            InventoryInventory_item::find($request->input('id_delete'))->delete();
            session()->flash('success', 'The item has been deleted');
            return redirect()->route('sett.inventory_item.index');
        }else{
            session()->flash('error_delete', 'The item has been used before');
            return redirect()->route('sett.inventory_item.index');
        }
        
    }
}