<?php
use App\Http\Controllers\Branch\OperationController;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

Route::group(
    [
         'prefix' => LaravelLocalization::setLocale(),
         'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
    ],
    function () {

        Route::prefix('prox')->name('sett.')->group(function () {
            Route::group(['prefix' => 'appo', 'middleware' => ['role:Super-admin|Branch-manager|Receptionist|Call-center|Doctor|Operation|Operation_doctor']], function () {

                /*
                |--------------------------------------------------------------------------
                |  Operations
                |--------------------------------------------------------------------------
                */
                //Operation API routes
                    //GET Routes
                        //get the services for appointment
                        Route::get('/fetch_servicecat_ajax_operation/{search_query}', [OperationController::class, 'fetch_servicecat_ajax_operation'])->name('app_fetch_servicecat_ajax_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                        //get the operation info from the timeslot
                        Route::get('/appointment_info_ajax_operation/{id}', [OperationController::class, 'appointment_info_ajax_operation'])->name('app_appointment_info_ajax_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                    //PUT/PATCH/POST Requests Routes
                        //update past operation note
                        Route::put('/operation_patient_past_note', [OperationController::class, 'operation_patient_past_note'])->name('operation_patient_past_note')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                        //update info during operation
                        Route::put('/operation_patient_during_op_upd', [OperationController::class, 'operation_patient_during_op_upd'])->name('operation_patient_during_op_upd')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);

                        //Operation follow up
                        Route::put('/op_follow_up_file_update/{id}', [OperationController::class, 'op_follow_up_file_update'])->name('op_follow_up_file_update')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                        Route::post('/op_follow_up_file_store/{id}', [OperationController::class, 'op_follow_up_file_store'])->name('op_follow_up_file_store')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                        //add info during operation
                        Route::post('/operation_patient_during_op', [OperationController::class, 'operation_patient_during_op'])->name('operation_patient_during_op')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                        //add gallery to operation
                        Route::post('/operation_patient_add_gallery', [OperationController::class, 'operation_patient_add_gallery'])->name('operation_patient_add_gallery')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                        //edit operation from patient profile
                        Route::PUT('/operation_patient_edit', [OperationController::class, 'operation_patient_edit'])->name('app_operation_patient_edit')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);

                        //store operation from patient profile
                        Route::post('/operation_patient_add', [OperationController::class, 'operation_patient_add'])->name('app_operation_patient_add')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                        //update appointment status
                        Route::PATCH('/update_status_doctor_operation/{id}', [OperationController::class, 'update_status_doctor_operation'])->name('app_update_status_doctor_operation')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                    //DELETE Routes
                        //delete gallery img
                        Route::delete('/operation_patient_delete_gallery', [OperationController::class, 'operation_patient_delete_gallery'])->name('operation_patient_delete_gallery')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                //Operation routes that return VIEWS
                    //show gallery op in different page
                    Route::get('/operation_gallery/{id}', [OperationController::class, 'operation_gallery'])->name('operation_gallery')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;

                    //Operation follow up
                    Route::get('/op_follow_up', [OperationController::class, 'op_follow_up'])->name('op_follow_up')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                    Route::get('/op_follow_up_show/{id}', [OperationController::class, 'op_follow_up_show'])->name('op_follow_up_show')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);
                    Route::get('/op_follow_up_file_insert/{id}', [OperationController::class, 'op_follow_up_file_insert'])->name('op_follow_up_file_insert')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                    Route::get('/op_follow_up_inprog', [OperationController::class, 'op_follow_up_inprog'])->name('op_follow_up_inprog')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                    Route::get('/op_follow_up_done', [OperationController::class, 'op_follow_up_done'])->name('op_follow_up_done')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;
                    Route::get('/op_follow_up_today', [OperationController::class, 'op_follow_up_today'])->name('op_follow_up_today')->middleware(['role:Super-admin|Doctor|Operation|Operation_doctor']);;




            });
        });
    });
