@extends('layouts.master')

@section('title', 'My Patients | Proxima - Medical Management app')

@section('title-topbar', 'My Patients')

<!-- css insert -->
@section('css')

@endsection

<!-- content insert -->

<!-- content insert -->
@section('content')

    <div class="container-fluid px-md-2 mt-3">

        <!-- page title link -->
        <div class="d-sm-flex align-items-center justify-content-between mb-3">
            <span class="mb-0">
                <a class="link-cust-text text-gray-200 fw-light"
                    href="{{ route('sett.home') }}">{{ __('basic.dashboard') }} |</a>
                <a class="link-cust-text text-gray-200 fw-light"
                    href="{{ route('sett.patient.index') }}">{{ __('basic.patients') }} | </a>
                <a class="text-gray-300">My Patients</a>
            </span>
        </div>



        <div class="row">

            <div class="col me-0 me-md-3 mb-3 mb-md-0 px-0 ">

                <div class="position-relative" style="top: 0; left: 0; width: 100%; height: 100%;">
                    <div class="bg-white b-r-s-cont shadow pb-4 position-sticky top-0">
                        <h6 class="mb-0 p-3 main-color-bg text-white" style="border-radius: 18px 18px 0px 0px;"><i
                                class="fas fa-filter"></i> {{ __('basic.search filter') }}</h6>

                        <form id="myform" class="mt-1" method="GET"
                            action="{{ route('sett.pat_show_all_patients') }}">
                            @csrf

                            <div class="accordion search-accordion" id="accordionExample">

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingSpec">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseSpec" aria-expanded="true" aria-controls="collapseOne">
                                            <i class="fas fa-map-marker-alt me-1"></i> {{ __('basic.specialty') }}
                                        </button>
                                    </h2>
                                    <div id="collapseSpec" class="accordion-collapse collapse show"
                                        aria-labelledby="headingSpec" data-bs-parent="#accordionExample">
                                        <div class="accordion-body py-0 px-3">

                                            <div class="form-group">
                                                @foreach ($specialty as $item)
                                                    <div class="form-check mb-1">
                                                        <input class="form-check-input" value="{{ $item->id }}"
                                                            type="radio" name="specialty_srch" id="{{ $item->id }}">
                                                        <label class="form-check-label" for="{{ $item->id }}">
                                                            {{ $item->name }}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                            <i class="fas fa-map-marker-alt me-1"></i> {{ __('basic.branch') }}
                                        </button>
                                    </h2>
                                    <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne"
                                        data-bs-parent="#accordionExample">
                                        <div class="accordion-body py-0 px-3">

                                            <div class="form-group">
                                                @foreach ($branch as $item)
                                                    <div class="form-check mb-1">
                                                        <input class="form-check-input" value="{{ $item->id }}"
                                                            type="radio" name="branch_srch" id="{{ $item->id }}">
                                                        <label class="form-check-label" for="{{ $item->id }}">
                                                            {{ $item->name }}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#country_side_search" aria-expanded="false"
                                            aria-controls="country_side_search">
                                            <i class="fas fa-globe-africa me-1"></i> {{ __('patientappo.country') }}
                                        </button>
                                    </h2>
                                    <div id="country_side_search" class="accordion-collapse collapse"
                                        aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                        <div class="accordion-body py-0 px-3">

                                            <div class="form-group">
                                                @foreach ($country as $item)
                                                    <div class="form-check mb-1">
                                                        <input class="form-check-input" value="{{ $item->country_id }}"
                                                            type="radio" name="country_srch"
                                                            id="{{ $item->country_id }}">
                                                        <label class="form-check-label" for="{{ $item->country_id }}">
                                                            {{ $item->country->name }}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#city_side_search" aria-expanded="false"
                                            aria-controls="city_side_search">
                                            <i class="fas fa-map-marked-alt me-1"></i> {{ __('patientappo.city') }}
                                        </button>
                                    </h2>
                                    <div id="city_side_search" class="accordion-collapse collapse"
                                        aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                        <div class="accordion-body py-0 px-3">

                                            <div class="form-group">
                                                @foreach ($city as $item)
                                                    <div class="form-check mb-1">
                                                        <input class="form-check-input" value="{{ $item->city_id }}"
                                                            type="radio" name="city_srch" id="{{ $item->city_id }}">
                                                        <label class="form-check-label" for="{{ $item->city_id }}">
                                                            {{ $item->city->name }}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#gendar_side_search" aria-expanded="false"
                                            aria-controls="gendar_side_search">
                                            <i class="fas fa-venus-mars me-1"></i> {{ __('patientappo.gendar') }}
                                        </button>
                                    </h2>
                                    <div id="gendar_side_search" class="accordion-collapse collapse"
                                        aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                        <div class="accordion-body py-0 px-3">

                                            <div class="form-group">

                                                <div class="form-check mb-1">
                                                    <input class="form-check-input" value="male" type="radio"
                                                        name="gendar_srch" id="male">
                                                    <label class="form-check-label" for="male">
                                                        {{ __('patientappo.male') }}
                                                    </label>
                                                </div>
                                                <div class="form-check mb-1">
                                                    <input class="form-check-input" value="female" type="radio"
                                                        name="gendar_srch" id="female">
                                                    <label class="form-check-label" for="female">
                                                        {{ __('patientappo.female') }}
                                                    </label>
                                                </div>

                                            </div>

                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="d-flex justify-content-center align-items-center mt-3">
                                <a class="text-gray-300 me-2"
                                    href="{{ route('sett.pat_show_all_patients') }}">{{ __('basic.reset') }}</a>
                                <button class="btn btn-primary px-4">{{ __('basic.search') }}</button>
                            </div>
                        </form>

                    </div>

                </div>

            </div>

            <div class="col-12 col-md-9">

                <p class="text-gray-400 mb-2">{{ __('patientappo.total patients') }}
                    <span>{{ $patients->total() }}</span>
                </p>

                <div>
                    @foreach ($patients as $item)
                        <div class="row align-items-center shadow b-r-s-cont bg-white overflow-scroll p-2 mb-2">

                            <div class="col-12 col-md-5 d-flex align-items-center mb-2 mb-md-0">
                                <img class="rounded-circle avatar-small2 me-3"
                                    src="{{ URL::asset('img/useravatar/' . $item->avatar) }}">
                                <div class="">
                                    <p class="mb-0 text-xs text-gray-300">
                                        {{ date('d M Y', strtotime($item->created_at)) }}</p>
                                    <a href="{{ route('sett.patient.show', $item->id) }}"
                                        class="mb-1 fw-bold text-s text-gray-600">
                                        {{ $item->name }}
                                    </a>
                                    <p class="mb-0 text-xs text-gray-400"><strong>
                                            {{ $item->branch->name }}
                                        </strong></p>
                                </div>
                            </div>

                            <div class="col text-center">
                                <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.phone number') }}</h6>
                                <h6 class="text-s text-gray-500 text-truncate">{{ $item->phone_number }}
                                </h6>
                            </div>

                            <div class="col text-center">
                                <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.country') }}</h6>
                                <h6 class="text-s text-gray-500 text-truncate">{{ $item->country->name }}
                                </h6>
                            </div>

                            <div class="col text-center">
                                <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.city') }}</h6>
                                <h6 class="text-s text-gray-500 text-truncate">{{ $item->city->name }}
                                </h6>
                            </div>

                            <div class="col text-center">
                                <h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.age') }}</h6>
                                <h6 class="text-s text-gray-500 text-truncate">
                                    {{ \Carbon\Carbon::parse($item->birthday)->diff(\Carbon\Carbon::now())->format('%y Years') }}
                                </h6>
                            </div>

                        </div>
                    @endforeach
                </div>

                <div class="d-flex mt-4 justify-content-end">
                    {{ $patients->appends(request()->input())->links() }}
                </div>

            </div>
        </div>


    </div>

@endsection


<!-- js insert -->
@section('js')

    <script>
        $(document).ready(function() {

            //--------------------- fetch appoingtments -------------------


            //rate insert
            $(document).on('keyup', '#search-eng', function() {

                var patient_username = $(this).val();


                var url = "{{ route('sett.app_arrived_patient_qr_update', ':id') }}";
                url = url.replace(':id', patient_username);

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        '_token': "{{ csrf_token() }}",
                        '_method': "PATCH",
                        'status': 4,
                    },
                    success: function(data) {
                        if (data.status == 1) {
                            $("#successful_msg").html(' ').show();
                            $("#successful_msg").html(
                                '<div class="flash-msg shadow pt-3 text-center" style="background-color: #20cd7d;">' +
                                '<div class="mb-2">' +
                                '<i class="far fa-smile-beam text-xl"></i>' +
                                '</div>' +
                                '<h3>Welcome ' + data.name + '!</h3>' +
                                '<p style="color:#cfffe4">Happy to see you again</p>' +
                                '</div>').delay(5000).fadeOut()
                            $("#search-eng").val('');
                        } else {
                            $("#successful_msg").html(' ').show();
                            $("#successful_msg").html(
                                '<div class="flash-msg shadow pt-3 text-center" style="background-color:#ff4152;">' +
                                '<div class="mb-2 text-center">' +
                                '<i class="text-center far fa-frown text-xl"></i>' +
                                '</div>' +
                                '<h3>Sorry, it is invalid QR or date</h3>' +
                                '<p style="color:#ffb4bc">Please try again</p>' +
                                '</div>').delay(5000).fadeOut()
                            $("#search-eng").val('');
                        }
                    }
                });

            });

        });
    </script>

@endsection
