@extends('layouts.master')

@section('title', 'New Appointment | Proxima - Medical Management app')

@section('title-topbar', 'New Appointment')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- international telephone input -->
<link href="{{ URL::asset('plugins/intltelinput/intlTelInput.css') }}" rel="stylesheet">

@endsection


<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">{{ __('basic.dashboard') }}
                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.appointment.index') }}">{{
                __('basic.appointment') }}
                | </a>
            <a class="text-gray-300">{{ __('basic.new appointment') }}</a>
        </span>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-calendar me-2"></i>
                {{ __('basic.new appointment') }}
            </h6>
        </div>

        <!-- Card Body -->
        <div class="card-body px-3">

            @foreach ($errors->all() as $error)
            <div class="text-red"><i class="fas fa-exclamation me-1"></i> {{ $error }}</div>
            @endforeach

            <div class="multi-setps-form-calander col-12">

                <form id="myform" method="POST" action="{{ route('sett.appointment.store') }}"
                    enctype="multipart/form-data">

                    @csrf

                    <!-- progressbar -->
                    <ul class="ps-0 progressbar" id="progressbar">
                        <li class="active">
                            <a>
                                <!-- in case we want to use prog selector href="#clinics" -->
                                <div class="icon-circle checked d-flex align-items-center justify-content-center">
                                    <i class="bi bi-calendar4-range"></i>
                                </div>
                                {{ __('basic.time') }}
                            </a>
                        </li>

                        <li>
                            <a>
                                <div class="icon-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-person"></i>
                                </div>
                                {{ __('basic.patient') }}
                            </a>
                        </li>

                        <li>
                            <a>
                                <div class="icon-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-info"></i>
                                </div>
                                {{ __('basic.details') }}
                            </a>
                        </li>
                        <li>
                            <a>
                                <div class="icon-circle d-flex align-items-center justify-content-center">
                                    <i class="far fa-paper-plane"></i>
                                </div>
                                {{ __('basic.sending') }}
                            </a>
                        </li>
                    </ul>

                    <!-- content -->

                    <div class="cont_tap px-0" id="clinics">

                        <div class="row justify-content-center mb-4">
                            <h5 class="text-center text-gray-400 mb-4">{{ __('patientappo.nearest clinic') }}
                            </h5>

                            <div class="row justify-content-center">

                                <div class="col ps-lg-5 pe-0 pe-md-5 mb-3 mb-md-0">

                                    <div class="my-3">
                                        <label class="form-label">{{ __('basic.specialty') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select id="specialty_selc_form"
                                            class="js-example-basic-single select2-no-search select2-hidden-accessible @error('specialty_id') is-invalid @enderror"
                                            name="specialty_id" required>
                                            @foreach ($specialties as $iteam)
                                            <option value="{{ $iteam->id }}" data-specialty_name="{{ $iteam->name }}">
                                                {{ $iteam->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        @error('specialty_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="my-3">
                                        <label class="form-label">{{ __('basic.branch') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select id="branches_selc_form"
                                            class="js-example-basic-single select2-no-search select2-hidden-accessible @error('branch_id') is-invalid @enderror"
                                            name="branch_id" required>
                                            @foreach ($branches as $iteam)
                                            <option value="{{ $iteam->id }}" data-branch_name="{{ $iteam->name }}"
                                                data-branch_address="{{ $iteam->address }}">
                                                {{ $iteam->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        @error('branch_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="my-3">
                                        <label class="form-label">{{ __('basic.unit') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select id="units_selc_form"
                                            class="js-example-basic-single select2-no-search select2-hidden-accessible @error('unit_id') is-invalid @enderror"
                                            name="unit_id" required>
                                            <option disabled>- Select Branch First -</option>
                                        </select>

                                        @error('unit_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="my-3">
                                        <label class="form-label">{{ __('basic.service') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select id="services"
                                            class="js-example-basic-single select2-hidden-accessible @error('service_id') is-invalid @enderror"
                                            name="service_id" required>
                                            <option disabled>- Select Speciality First -</option>
                                        </select>

                                        @error('service_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="mt-4 d-flex justify-content-between">

                                        <div class="">
                                            {{ __('patientappo.online appointment') }}
                                        </div>

                                        <div class="
                                                switch-checkbox">
                                            <input name="online_appointment" type="checkbox" value="1"
                                                id="switch"><label for="switch">Toggle</label>
                                        </div>

                                    </div>
                                </div>

                                <!-- calander -->
                                <div
                                    class="col position-relative px-0 ps-md-4 justify-content-sm-center calander-left-border text-center align-self-center">



                                    <div class="calander_cont mx-auto position-relative">

                                        <div id="calander_cont">
                                            <!-- calander ajax content -->
                                        </div>
                                    </div>

                                    <!-- showing waiting during ajax performance -->
                                    <div id="waiting" class="w-100 h-100 text-center"
                                        style="position: absolute; top:0px; left:0px;z-index:999999; background-color: #ffffffba;">
                                        <div class="spinner-grow text-primary" role="status"
                                            style="position: relative; top: 50%; transform: translateY(-50%);">
                                            <span class="sr-only">Loading...</span>
                                        </div>
                                    </div>

                                    <input type="hidden" name="calander_date_day" id="calander_date_day" value=""
                                        required>
                                    <input type="hidden" name="calander_date_start" id="calander_date_start" value="">
                                    <input type="hidden" name="calander_date_end" id="calander_date_end" value="">

                                    @error('calander_date_day')
                                    <span class="error-msg-form text-center">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>

                            </div>


                        </div>

                        <div class="d-flex justify-content-end p-4 py-0">
                            <input type="button" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="{{ __('basic.continue') }}" />
                        </div>
                    </div>

                    <!-- slide 2 -->

                    <div class="cont_tap px-2" id="time">

                        <div class="row justify-content-around">

                            <div class="col-12">

                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                                            data-bs-target="#home" type="button" role="tab" aria-controls="home"
                                            aria-selected="true" class="text-gray-500"><i class="fas fa-user me-1"></i>
                                            {{ __('basic.patient') }}</button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link" id="profile-tab" data-bs-toggle="tab"
                                            data-bs-target="#profile" type="button" role="tab" aria-controls="profile"
                                            aria-selected="false" class="main-color"><i class="fas fa-plus me-1"></i> {{
                                            __('basic.new') }}</button>
                                    </li>
                                </ul>

                                <div class="tab-content" id="myTabContent">

                                    <!-- search for patients -->
                                    <div class="tab-pane fade show active" id="home" role="tabpanel"
                                        aria-labelledby="home-tab">

                                        <div class="row pt-5 justify-content-center">

                                            <h5 class="text-center text-gray-400">
                                                {{ __('patientappo.patient for appointment') }}
                                            </h5>

                                            <div class="col-12 col-md-9 my-4">

                                                <div class="search-eng-cont-calander">

                                                    <div class="p-1 bg-white rounded rounded-pill border-all"
                                                        style="box-shadow: -1px 1rem 1rem 7px rgb(58 59 69 / 15%) !important; ">

                                                        <div class="input-group">
                                                            <input id="search-eng" type="search"
                                                                placeholder="{{ __('patientappo.patient search msg') }}"
                                                                aria-describedby="button-add"
                                                                class="form-control border-0 bg-transparent px-4"
                                                                required>
                                                            <div class="input-group-append pe-2">
                                                                <button class="btn btn-link text-primary typeahead"><i
                                                                        class="fa fa-search text-gray-300"></i></button>
                                                            </div>
                                                        </div>

                                                    </div>

                                                </div>

                                                @error('search_patient_id')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                                <!-- patient id from search bar via ajax-->
                                                <input type="hidden" name="search_patient_id" id="search_patient_id"
                                                    data-name="" data-phone_number="" value="" required>

                                                <div id="search-eng-js-error-valid"></div>

                                            </div>


                                            <div class="col-12 mt-4 position-relative">

                                                <!-- showing waiting during ajax performance -->
                                                <div id="waiting2" class="w-100 h-100 text-center"
                                                    style="position: absolute; top:0px; left:0px;z-index:999999; background-color: #ffffffba;">
                                                    <div class="spinner-grow text-primary" role="status"
                                                        style="position: relative; top: 50%; transform: translateY(-50%);">
                                                        <span class="sr-only">Loading...</span>
                                                    </div>
                                                </div>

                                                <h6 id="hid-info-search" class="text-gray-600 mb-3"
                                                    style="display: none">{{ __('patientappo.patient info') }} </h6>
                                                <div id="patient_info_ajax">
                                                    <!-- to get the patient info from ajax -->
                                                </div>

                                                <div class="d-flex justify-content-between p-4 pb-0">
                                                    <input type="button" name="previous"
                                                        class="previous-form-steps btn btn-secondary action-button-previous me-3"
                                                        value="{{ __('basic.previous') }}">
                                                </div>
                                            </div>

                                        </div>


                                    </div>



                                    <div class="tab-pane fade" id="profile" role="tabpanel"
                                        aria-labelledby="profile-tab">

                                        <h5 class="text-gray-400 mt-4">{{ __('patientappo.new patient') }}
                                        </h5>

                                        <div class="row mb-1 mt-5">

                                            <div class="col-12 col-md-5 align-self-center mb-2">
                                                <div class="avatar-update-container">
                                                    <div class="picture">
                                                        <img src="{{ URL::asset('img/dashboard/avatars/default-pp.png') }}"
                                                            class="picture-src" id="mib_PicturePreview" title="" />
                                                        <input type="file" name='avatar' accept="image/*"
                                                            id="mib_img_input">
                                                    </div>
                                                    <h6 class="text-gray-300">{{ __('basic.choose pic') }}</h6>

                                                    @error('avatar')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-12 col-md-7 mb-2">
                                                <div class="mb-3">
                                                    <label class="form-label">{{ __('patientappo.first name') }}
                                                        <small>({{ __('basic.required') }})</small></label>
                                                    <input name="first_name" type="text"
                                                        class="form-control @error('first_name') is-invalid @enderror"
                                                        placeholder="Write your first name here" required
                                                        value="{{ old('first_name') }}">
                                                </div>

                                                @error('first_name')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                                <div class="mb-3">
                                                    <label class="form-label">{{ __('patientappo.second name') }}
                                                        <small>({{ __('basic.required') }})</small></label>
                                                    <input name="second_name" type="text"
                                                        class="form-control @error('second_name') is-invalid @enderror"
                                                        placeholder="Write your second name here" required
                                                        value="{{ old('second_name') }}">
                                                </div>

                                                @error('second_name')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>

                                        </div>

                                        <div class="row mb-2">
                                            <div class="col-12 col-md-6 mb-2">
                                                <label class="form-label">{{ __('patientappo.password') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <input id="password" name="password" type="password"
                                                    class="form-control @error('password') is-invalid @enderror"
                                                    placeholder="Wrtie your password here..." required>

                                                @if ($errors->has('password'))
                                                <span class="error-msg-form">
                                                    {{ $errors->first('password') }}
                                                </span>
                                                @else
                                                <div class="form-text text-gray-200">
                                                    {{ __('patientappo.password msg') }}
                                                </div>
                                                @endif
                                            </div>


                                            <div class="col-12 col-md-6 mb-2">
                                                <label class="form-label">{{ __('patientappo.confirm password') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <input name="password_confirmation" type="password" class="form-control"
                                                    placeholder="Confirm your password..." id="password-confirm"
                                                    required>
                                            </div>

                                        </div>

                                        <hr>
                                        <h6 class="text-gray-400 mb-">
                                            {{ __('patientappo.additional personal information') }}
                                        </h6>

                                        <div class="row mb-2">

                                            <div class="col-12 col-md-6 mb-2">
                                                <label class="form-label">{{ __('patientappo.email') }}
                                                    <small>({{ __('basic.optional') }})</small></label>
                                                <input name="email" type="text"
                                                    class="form-control @error('email') is-invalid @enderror"
                                                    placeholder="Yousef@gmail.com..." value="{{ old('email') }}">
                                                @error('email')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-12 col-md-6 mb-2">
                                                <label class="form-label">{{ __('patientappo.mother name') }}
                                                    <small>({{ __('basic.optional') }})</small></label>
                                                <input name="mother_name" type="text"
                                                    class="form-control @error('mother_name') is-invalid @enderror"
                                                    placeholder="Write your mother's name here"
                                                    value="{{ old('mother_name') }}">

                                                @error('mother_name')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                        </div>

                                        <div class="row mb-2">

                                            <div class="col-12 col-md-4 mb-2">
                                                <label class="form-label">{{ __('basic.branch') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <select
                                                    class="js-example-basic-single select2-no-search select2-hidden-accessible @error('first_branch_id') is-invalid @enderror"
                                                    name="first_branch_id" required>
                                                    @foreach ($branches as $iteam)
                                                    <option @if (old('first_branch_id')===$iteam->id) selected @endif
                                                        value="{{ $iteam->id }}">{{ $iteam->name }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                                <div id="first_branch_id-js-error-valid"></div>

                                                @error('first_branch_id')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-12 col-md-4 mb-2">
                                                <label class="form-label">{{ __('patientappo.gendar') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <select
                                                    class="js-example-basic-single select2-no-search select2-hidden-accessible @error('gendar') is-invalid @enderror"
                                                    name="gendar" required>
                                                    <option @if (old('gendar')==='male' ) selected @endif value="male">
                                                        {{ __('patientappo.male') }}</option>
                                                    <option @if (old('gendar')==='female' ) selected @endif
                                                        value="female">{{ __('patientappo.female') }}</option>
                                                </select>
                                                <div id="gendar-js-error-valid"></div>

                                                @error('gendar')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-12 col-md-4 mb-2">

                                                <label class="form-label">{{ __('patientappo.birthday') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <div class="input-group-text"><i
                                                                class="bi bi-calendar2-week-fill"></i> </div>
                                                    </div>
                                                    <input name="birthday" type="text"
                                                        class="form-control hasdatetimepicker @error('birthday') is-invalid @enderror"
                                                        placeholder="YYYY/MM/DD" required value="@if(old('birthday'))
                                                        {{ old('birthday') }}
                                                        @else {{ date(" Y-m-d") }} @endif">
                                                </div>
                                                <div id="birthday-js-error-valid"></div>

                                                @error('birthday')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>

                                        </div>


                                        <div class="row mb-2">

                                            <div class="col-12 col-md-4 mb-2">
                                                <label class="form-label">{{ __('patientappo.country') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <select
                                                    class="js-example-basic-single select2-hidden-accessible @error('country_id') is-invalid @enderror"
                                                    name="country_id" required>
                                                    @foreach ($countries as $iteam)
                                                    <option value="{{ $iteam->id }}">{{ $iteam->name }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                                <div id="country-js-error-valid"></div>

                                                @error('country_id')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>

                                            <div class="col-12 col-md-4 mb-2">
                                                <label class="form-label">{{ __('patientappo.city') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <select
                                                    class="js-example-basic-single select2-hidden-accessible @error('city_id') is-invalid @enderror"
                                                    name="city_id" required>
                                                    <option disabled selected>Open this select menu</option>
                                                </select>

                                                <div id="city-js-error-valid"></div>

                                                @if ($errors->has('city_id'))
                                                <span class="error-msg-form">
                                                    {{ $errors->first('city_id') }}
                                                </span>
                                                @else
                                                <div class="form-text text-gray-200">
                                                    {{ __('patientappo.city msg') }}
                                                </div>
                                                @endif
                                            </div>


                                            <div class="col-12 col-md-4 mb-2">
                                                <label class="form-label">{{ __('patientappo.know us') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <select
                                                    class="js-example-basic-single select2-hidden-accessible select2-no-search @error('from_recourse_id') is-invalid @enderror"
                                                    name="from_recourse_id">
                                                    @foreach ($from_recourses as $iteam)
                                                    <option @if (old('from_recourse_id')===$iteam->id) selected @endif
                                                        value="{{ $iteam->id }}">{{ $iteam->name }}
                                                    </option>
                                                    @endforeach
                                                </select>

                                                <div id="from-recourse-js-error-valid"></div>

                                                @error('from_recourse_id')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>

                                        </div>


                                        <hr>
                                        <h6 class="text-gray-400 mb-">{{ __('patientappo.contact information') }}
                                        </h6>

                                        <div class="row mb-2">

                                            <div class="col-12 col-md-4 mb-2">
                                                <label class="form-label">{{ __('patientappo.phone number') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <input id="int-miphone" name="phone_number" type="tel"
                                                    class="form-control @error('phone_number') is-invalid @enderror"
                                                    required value="{{ old('phone_number') }}">

                                                <div id="phonenumber-js-error-valid"></div>

                                                @if ($errors->has('phone_number'))
                                                <span class="error-msg-form">
                                                    {{ $errors->first('phone_number') }}
                                                </span>
                                                @else
                                                <div class="form-text text-gray-200">We'll never share your email
                                                    with anyone else.
                                                </div>
                                                @endif
                                            </div>

                                            <div class="col-12 col-md-4 mb-2">
                                                <label class="form-label">{{ __('patientappo.second phone number') }}
                                                    <small>({{ __('basic.optional') }})</small></label>
                                                <input id="int-miphone2" name="sec_phone_number" type="tel"
                                                    class="form-control @error('sec_phone_number') is-invalid @enderror"
                                                    value="{{ old('sec_phone_number') }}">

                                                <div id="secphonenumber-js-error-valid"></div>

                                                @error('sec_phone_number')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-12 col-md-4 mb-2">
                                                <label class="form-label">{{ __('patientappo.insurance') }}<small>
                                                        ({{ __('basic.optional') }})</small></label>
                                                <input name="insurance" type="text"
                                                    class="form-control @error('insurance') is-invalid @enderror"
                                                    placeholder="Write your insurance company here"
                                                    value="{{ old('insurance') }}">

                                                @error('insurance')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror

                                            </div>

                                        </div>

                                        <div class="d-flex justify-content-between p-4 pb-0">
                                            <input type="button" name="{{ __('basic.previous') }}"
                                                class="previous-form-steps btn btn-secondary action-button-previous me-3"
                                                value="{{ __('basic.previous') }}" />
                                            <input type="button" name="next"
                                                class="next-form-steps search-select-btn btn btn-primary action-button-next"
                                                value="{{ __('basic.continue') }}" />
                                        </div>
                                    </div>
                                </div>

                            </div>

                        </div>

                    </div>

                    <!-- slide 3 appointment info -->

                    <div class="cont_tap px-2" id="about">

                        <!--
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                <div class="text-end px-lg-5">
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                <a href="#"
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                class="d-none bg-white d-sm-inline-block btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                class="fas fa-download fa-sm text-gray-300 me-1"></i> Print</a> </div> -->

                        <div class="d-flex justify-content-around align-items-center flex-wrap mt-4">

                            <div class="d-flex mb-4 align-items-center me-2 mb-2">
                                <img id="avatar_final_info" class="rounded-circle avatar-m me-3"
                                    src="{{ URL::asset('img/dashboard/avatars/GGeMmsPz.jpeg') }}">
                                <div class="">
                                    <p class=" mb-0 text-xs text-gray-300">
                                        {{ __('basic.patient') }}</p>
                                    <h5 id="name_final_info" class="mb-1 fw-bold text-gray-600">
                                        {{ __('basic.not selected') }}
                                    </h5>
                                    <p id="number_final_info" class="mb-0 text-xs text-gray-400">
                                        {{ __('basic.not selected') }}</p>
                                </div>
                            </div>

                            <div class="me-2">
                                <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.branch') }}</h6>
                                <p id="branch_final_info" class="text-gray-600 text-s fw-bold">
                                    {{ __('basic.not selected') }}</p>
                            </div>

                            <div class="me-2">
                                <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.address') }}</h6>
                                <p id="addre_final_info" class="text-gray-600 text-s fw-bold">
                                    {{ __('basic.not selected') }}</p>
                            </div>
                        </div>

                        <hr>

                        <div class="px-lg-5 mt-4">

                            <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3">
                                <div class="me-2">
                                    <i class="fas fa-stethoscope me-2 text-gray-400"></i>
                                    <span id="service_final_info">
                                        {{ __('basic.not selected') }}
                                    </span>
                                </div>
                                <div id="service_price_final_info" class="text-center">
                                    {{ __('basic.not selected') }}
                                </div>
                            </div>

                            <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3">
                                <div class="me-2">
                                    <i class="fas fa-tag me-2 text-gray-400"></i> {{ __('basic.coupon') }}
                                </div>

                                <div class="text-center">
                                    <div class="input-group">
                                        <input type="text" name="coupon_input" class="form-control custom-select"
                                            id="coupon_input" style="border-radius: 5px 0px 0px 5px !important;"
                                            placeholder="Discount code here ..">

                                        <input type="hidden" name="coupon_id" id="coupon_id">

                                        <div class="input-group-append">
                                            <button id="coupon-buttn" class="btn btn-outline-secondary"
                                                class="form-control " type="button">{{ __('basic.send') }}</button>
                                        </div>
                                    </div>

                                    @error('coupon_id')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror

                                    <div id="search-result-input"></div>

                                </div>
                            </div>

                            <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3 d-none"
                                id="discount_amount_div">
                                <div class="me-2">
                                    <i class="fas fa-percent me-2 text-gray-400"></i> Discount
                                </div>
                                <div id="discount_amount_place" class="text-center text-decoration-line-through">
                                    {{ __('basic.not selected') }}
                                </div>
                            </div>

                            <div class="d-flex justify-content-between align-items-center px-lg-5 mb-4">
                                <div class="me-2 fw-bold">
                                    <i class="fas fa-dollar-sign me-2"></i> {{ __('basic.total price') }}
                                </div>
                                <div id="price_total_final_info" class="fw-bold text-center">
                                    {{ __('basic.not selected') }}
                                </div>
                            </div>

                            <div class="row mb-2 px-lg-5">
                                <div class="mb-3">
                                    <label class="form-label">{{ __('basic.note') }}
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <textarea name="appointment_note" class="form-control"
                                        placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>
                                </div>
                            </div>

                            @error('appointment_note')
                            <span class="error-msg-form">
                                {{ $message }}
                            </span>
                            @enderror

                            <div class="row align-items-center main-color-bg text-white px-lg-5 b-r-s-cont px-4 py-4">
                                <div class="col-12 col-md text-blue-300 mb-2 mb-md-0">
                                    {{ __('patientappo.come before 15 msg') }}
                                </div>
                                <div class="col-12 col-md text-center">

                                    <h6 class="text-xs mb-1 text-blue-300">{{ __('basic.appointment time') }}</h6>
                                    <p id="date_final_info" class="text-l fs-4 fw-bold mb-0">
                                        {{ __('basic.not selected') }}</p>
                                    <p id="time_final_info" class="text-s text-blue-200">
                                        {{ __('basic.not selected') }}</p>
                                </div>

                            </div>

                        </div>

                        <div class="d-flex justify-content-between p-4">
                            <input type="button" name="previous"
                                class="previous-form-steps btn btn-secondary action-button-previous me-3"
                                value="{{ __('basic.previous') }}" />
                            <input type="submit" name="next" class="next-form-steps btn btn-primary action-button-next"
                                value="{{ __('basic.send') }}" />
                        </div>
                    </div>

                    <!-- slide 4 -->

                    <div class="cont_tap" id="sending">
                        <div class="d-flex justify-content-center p2">
                            <img src="{{ URL::asset('img/dashboard/system/loading-dash.svg') }}" style="width: 195px;"
                                alt="Loading" />
                        </div>
                    </div>

                </form>
            </div>

        </div>

    </div>
</div>

@endsection

<!-- js insert -->
@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
</script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            }).on('change', function(){
                $('.datepicker').hide();
            });
        });
</script>

<!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
        var $validator = $('#myform').validate({

            //ignore: [], //to enable vlidation for hidden inputs
            //ignore: ['#calander_date_daya'],
            onkeyup: false,
            ignore: ":hidden:not(#calander_date_day)", //select for enable hidden input

            rules: {
                first_name: {
                    minlength: 3,
                    maxlength: 30,
                },
                second_name: {
                    minlength: 3,
                    maxlength: 60,
                },
                mother_name: {
                    minlength: 4,
                    maxlength: 60,
                },
                email: {
                    email: true,
                },
                password: {
                    minlength: 7,
                    maxlength: 100,
                },
                password_confirmation: {
                    minlength: 7,
                    maxlength: 100,
                    equalTo: '#password',
                },
                appointment_note: {
                    maxlength: 255,
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'first_branch_id':
                        error.insertAfter($("#first_branch_id-js-error-valid"));
                        break;
                    case 'gendar':
                        error.insertAfter($("#gendar-js-error-valid"));
                        break;
                    case 'birthday':
                        error.insertAfter($("#birthday-js-error-valid"));
                        break;
                    case 'country_id':
                        error.insertAfter($("#country-js-error-valid"));
                        break;
                    case 'city_id':
                        error.insertAfter($("#city-js-error-valid"));
                        break;
                    case 'started_work':
                        error.insertAfter($("#startedwork-js-error-valid"));
                        break;
                    case 'phone_number':
                        error.insertAfter($("#phonenumber-js-error-valid"));
                        break;
                    case 'sec_phone_number':
                        error.insertAfter($("#secphonenumber-js-error-valid"));
                        break;
                    case 'from_recourse_id':
                        error.insertAfter($("#from-recourse-js-error-valid"));
                        break;
                    case 'search-eng':
                        error.insertAfter($("#search-eng-js-error-valid"));
                        break;

                    default:
                        error.insertAfter(element);
                }


            },
        });
</script>
<script>
    fetchServices_cat();

        function fetchServices_cat(specialty = $('#specialty_selc_form').val(), branch = $('#branches_selc_form').val()) {

            var url = "{{ route('sett.app_fetch_servicecat_ajax', [':date', ':date2']) }}";
            url = url.replace(':date', specialty).replace(':date2', branch);

            $.ajax({
                url: url,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    $('#services').empty();
                    $.each(data, function(key, value) {
                        $('#services').append('<option value="' +
                            value.id + '" data-price="' + value.price + '" data-name="' + value
                            .name + '">' + value.name + ' - ' + value.price +
                            ' {{ __('basic.egp') }}</option>');
                    });
                }
            });
        }


        //for showing loading icon until the ajax is done
        $(document).ajaxStart(function() {
            $("#waiting, #waiting2").show();
        });

        $(document).ajaxStop(function() {
            $("#waiting, #waiting2").hide();
        });

        //insert passwrod depends on the username
        $('input[name="first_name"]').keyup(function(e) {
            e.preventDefault();

            first_name = $(this).val();
            new_password = 'prox' + first_name;
            $('input[name="password"]').val(new_password);
            $('input[name="password_confirmation"]').val(new_password);
        })

        fetchCity();

        //for country and cities ajax inputs
        function fetchCity(countryID = $('select[name="country_id"]').val()) {

            var url = "{{ route('sett.createcityajax', ':id') }}";
            url = url.replace(':id', countryID);

            if (countryID) {
                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('select[name="city_id"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="city_id"]').append('<option value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            } else {
                $('select[name="city_id"]').empty();
            }
        }

        $('select[name="country_id"]').on('change', function(e) {
            var country_id = $(this).val();
            fetchCity(country_id)
        });
</script>


<script>
    //--------------------- calander appointment ajax -------------------

        //default calander ajax
        $(document).ready(function() {

            fetchCalander();

            function fetchCalander(month = {{ date('m') }}, year = {{ date('Y') }}) {
                var specialty_selc = $('#specialty_selc_form').val();
                var branch_id = $('#branches_selc_form').val();
                var unit_id = $('#units_selc_form').val();

                console.log(unit_id);
                var url =
                    "{{ route('sett.appcalander_appointment_ajax', [':month', ':year', ':specialty_id', ':branch_id', ':unit_id']) }}";
                url = url.replace(':month', month).replace(':year', year).replace(':specialty_id', specialty_selc)
                    .replace(':branch_id', branch_id).replace(':unit_id', unit_id);

                $.ajax({
                    url: url,
                    type: "GET",
                    success: function(data) {
                        $("#calander_cont").html(data);
                    }
                });
            }

            //to get unit depnds on branch selected
            fetchUnit();

            function fetchUnit(branch = $('#branches_selc_form').val()) {

                var url = "{{ route('sett.app_fetch_unit_ajax', [':date']) }}";
                url = url.replace(':date', branch);

                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('#units_selc_form').empty();
                        $.each(data, function(key, value) {
                            $('#units_selc_form').append('<option value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                        $('#units_selc_form').append(
                            '<option value="0"> Witing List</option>');
                        fetchCalander()
                    }
                });
            }



            //reinsert calander when specialty selector is changed (#specialty_selc_form)
            $(document).on('change', '#specialty_selc_form', function() {
                var specialty_id = $('#specialty_selc_form').val();
                var branch_id = $('#branches_selc_form').val();

                $('.calendar_datapicker_timeslots').hide();

                fetchServices_cat(specialty_id, branch_id);
                fetchCalander()
            });

            //reinsert calander when branch selector is changed (#branches_selc_form)
            $(document).on('change', '#branches_selc_form', function() {
                var specialty_id = $('#specialty_selc_form').val();
                var branch_id = $('#branches_selc_form').val();

                $('.calendar_datapicker_timeslots').hide();

                fetchUnit(branch_id)
                fetchServices_cat(specialty_id, branch_id);
                fetchCalander()
            });

            $(document).on('change', '#units_selc_form', function() {
                fetchCalander()
            });

            //reinsert the calander when the month arrows are clicked
            $(document).on('click', '#change_month', function() {
                var month = $(this).data('month');
                var year = $(this).data('year');
                fetchCalander(month, year)
            });
        });

        $(document).on('click', '.show_slots', function() {

            var today_date = $(this).data('timeslots');
            var specialty_selc = $('#specialty_selc_form').val();
            var branches_selc = $('#branches_selc_form').val();
            var unit_id = $('#units_selc_form').val();

            var show_slots_div = $(this).next('.calendar_datapicker_timeslots');

            var url =
                "{{ route('sett.appcalander_show_slots_ajax', [':datetoday', ':specialty_id', ':branch_id', ':unit_id']) }}";
            url = url.replace(':datetoday', today_date).replace(':specialty_id', specialty_selc)
                .replace(':branch_id', branches_selc).replace(':unit_id', unit_id);

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    show_slots_div.html(data);
                }
            });

            show_slots_div.hide();
            show_slots_div.show().css({
                    'opacity': 0,
                    'bottom': '-21%'
                })
                .animate({
                    'opacity': '1',
                    'bottom': '5px'
                }, 400);

        });


        $(document).on('click', '.click_day_calendar-close', function() {
            $('.calendar_datapicker_timeslots').hide();
        })


        // ----------------- timeslots -----------------
        //-- to show the available timeslots for given day
        //when (#available_day_ajax) is clicked in calander days, (data-timeslots attribute) will be taken which containing the give date
        //it will be send to timeslots.php to selecet the booked date from db then check the availability and excute timeslot fun
        $(document).on('click', '.available_day_ajax-selector', function() {
            //to reomove first classes booked and add booked to the selected day in calander
            $('.available_day_ajax_selected').removeClass('selected_day_calander');
            $('.calendar_booking_time_div').removeClass('selected_day_calander');
            $('.td_calander ').removeClass('selected_main_day_calander');
            $(this).parent().parent().parent().parent().closest('div').addClass("selected_main_day_calander")
        });

        $(document).ready(function() {

            $(document).on('mouseover click', '.available_day_ajax-selector', function() {

                if ($("a.firstClick").length > 0 && $("a.secondClick").length > 0) {
                    if (event.type === "click") {
                        $('.available_day_ajax-selector').removeClass("selected_day_calander");
                        $('.available_day_ajax-selector').removeClass("reserved");
                        $('.available_day_ajax-selector').removeClass("firstClick");
                        $('.available_day_ajax-selector').removeClass("secondClick");
                    }
                }

                if ($("a.firstClick").length > 0 && $("a.secondClick").length == 0) {
                    if (event.type === "mouseover") {
                        $('.available_day_ajax-selector').removeClass("selected_day_calander");
                        var tds = $('a.available_day_ajax-selector');
                        var firstClick = $(".firstClick");
                        var firstClickIndex = tds.index(firstClick);
                        var currentIndex = tds.index(this);

                        tds.filter(function() {
                            var idx = tds.index(this);
                            return idx >= firstClickIndex && idx <= currentIndex;
                        }).addClass("selected_day_calander")

                    }
                    if (event.type === "click") {
                        $(this).addClass("secondClick");
                        $('.selected_day_calander').addClass('reserved');

                        $end = $(this).data("end");
                        $('#calander_date_end').val($end);
                    }
                } else {
                    if (event.type === "click") {
                        $(this).addClass("firstClick");

                        $day = $(this).data("day");
                        $start = $(this).data("start");
                        $('#calander_date_day').val($day);
                        $('#calander_date_start').val($start);
                        $('#calander_date_end').val('');
                    }
                }

            });

        });
</script>

<script>
    //--------------------- search engine ajax -------------------

        $(document).ready(function() {
            // Send Search Text to the server
            $("#search-eng").keyup(function() {

                let search_query = $(this).val();

                var url = "{{ route('sett.app_calander_patient_search', ':search_query') }}";
                url = url.replace(':search_query', search_query);

                if (search_query != "") {
                    $.ajax({
                        url: url,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {

                            avatar_url = '{{ URL::asset('img/useravatar') }}';

                            if (data !== "") {
                                $('#hid-info-search').show();

                                var html = ''
                                $.each(data, function(key, value) {
                                    if (value.recommendation == 1) {
                                        recom_color = 'main-color-bg-200';
                                        recom_msg = 'Normal';
                                    } else if (value.recommendation == 2) {
                                        recom_color = 'text-green-ligh-bg';
                                        recom_msg = 'Recommended';
                                    } else if (value.recommendation == 3) {
                                        recom_color = 'text-red-bg';
                                        recom_msg = 'Not recommended';
                                    }
                                    html +=
                                        '<div class="row border-top-gray py-4 align-items-center px-0 px-md-2">' +

                                        '<div class="col-6 col-md-5 d-flex mb-2 align-items-center">' +
                                        '<div class="position-relative">' +
                                        '<img class="rounded-circle avatar-small2 me-3" src=' +
                                        avatar_url + '/' + value.avatar +
                                        '><div data-toggle="tooltip" data-placement="top" title="' +
                                        recom_msg +
                                        '" class="status-indicator-img-small ' +
                                        recom_color + '"></div>' +
                                        '</div>' +
                                        '<div><p class = "mb-0 text-xs text-gray-300 ">{{ __('basic.patient') }} </p> <p class = "mb-0 text-xs fw-bold text-gray-600 " >' +
                                        value.name +
                                        '</p> </div> </div>' +

                                        '<div class="col-6 col-md mb-2 text-end text-md-start">' +
                                        '<h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.mother name') }}</h6>' +
                                        '<p class="text-gray-600 text-s fw-bold">' +
                                        value.mother_name + '</p></div>' +

                                        '<div class="col-6 col-md mb-2">' +
                                        '<h6 class="text-gray-300 text-xs mb-1">{{ __('patientappo.phone number') }}</h6>' +
                                        '<p class="text-gray-600 text-s fw-bold">' +
                                        value
                                        .phone_number + '</p></div>' +

                                        '<div class="col-6 col-md mb-2 text-end">' +
                                        '<input type="button" name="next" class="next-form-steps search-select-btn btn btn-primary" value="{{ __('basic.continue') }}" data-id="' +
                                        value.id + '" data-full_name="' +
                                        value.name + '" data-phone_number="' +
                                        value.phone_number + '" data-avatar="' + value
                                        .avatar + '">' +
                                        '</div>' +

                                        '</div>'
                                });

                                $('#patient_info_ajax').html(html);
                            }

                            if (data == "") {
                                $('#patient_info_ajax').html(
                                    '<a class="list-group-item list-group-item-action border-0 text-gray-700"><i class="fas fa-search text-gray-200 me-2"></i>No Record founded</a>'
                                );
                            }
                        },
                    });
                } else {
                    $('#hid-info-search').hide();
                    $("#patient_info_ajax").empty();
                }
            });

            //get the final details appointment to show in the last slide
            $(document).on("click", ".search-select-btn", function() {

                id = $(this).data('id');

                if (id !== undefined) {
                    console.log('undfiednd');
                    var name = $(this).data('full_name');
                    var phone_number = $(this).data('phone_number');
                    var avatar = $(this).data('avatar');
                } else {
                    var first_name = $("input[name=first_name]").val();
                    var second_name = $("input[name=second_name]").val();
                    var name = first_name + ' ' + second_name;
                    var phone_number = $("input[name=phone_number]").val();;
                    var avatar = 'default-pp.png';
                }

                var branch_name = $('#branches_selc_form').find(':selected').data('branch_name');
                var branch_address = $('#branches_selc_form').find(':selected').data('branch_address');
                var service_name = $('#services').find(':selected').data('name');
                var service_price = $('#services').find(':selected').data('price');

                var avatar_url = '{{ URL::asset('img/useravatar') }}';

                var date_final = $('#calander_date_day').val();
                var start_time_appo = $('#calander_date_start').val();
                var end_time_appo = $('#calander_date_end').val();
                var time_appointment = start_time_appo + " - " + end_time_appo;

                $('#search_patient_id').val(id);
                $("#avatar_final_info").attr("src", avatar_url + '/' + avatar);
                $('#name_final_info').text(name);
                $('#number_final_info').text(phone_number);
                $('#branch_final_info').text(branch_name);
                $('#addre_final_info').text(branch_address);
                $('#service_final_info').text(service_name);
                $('#service_price_final_info').text(service_price);
                $('#price_total_final_info').text(service_price);
                $('#date_final_info').text(time_appointment);
                $('#time_final_info').text(date_final);
            })

            //in case the user chosse new patient to add the appointment for
            $(document).on('click', '#profile-tab', function() {
                $("#search_patient_id").prop('disabled', true);
            });

            //in case the user chosse new patient to add the appointment for
            $(document).on('click', '#home-tab', function() {
                $("#search_patient_id").prop('disabled', false);
            });
        });
</script>


<script>
    //--------------------- coupons -------------------
        $(document).on('click', '#coupon-buttn', function() {

            var search_query = $('#coupon_input').val();
            var patient_check = $('#search_patient_id').val();
            //service price
            var total_price = $('#services').find(':selected').data('price');

            if (!patient_check) {
                var patient_id = 'null';
            } else {
                var patient_id = patient_check;
            }

            var url =
                "{{ route('sett.invo_coupon_search', [':search_query', ':patient_id', ':total_price']) }}";
            url = url.replace(':search_query', search_query).replace(':patient_id', patient_id).replace(
                ':total_price', total_price);

            $.ajax({
                url: url,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    //if the coupon is not valid or used before
                    if (!data.discount_amount) {
                        $('#coupon_input').val("")
                        $("#discount_amount_div").addClass('d-none');
                        $("#search-result-input").html('<p class="text-red-error">' + data.msg +
                            '</p>');
                        $("#price_total_final_info").html('$' + total_price);

                        //if the coupon is valid
                    } else {
                        $("#discount_amount_div").removeClass('d-none');

                        $("#search-result-input").html('<p class="me-2 text-green">' + data.msg +
                            '<small id="delete_coupon" class="text-red clickable-item-pointer"> DELETE</small><p>'
                        );
                        $("#discount_amount_place").html('$' + data.discount_amount);

                        //insert the coupon id to the hidden input
                        $("#coupon_id").val(data.id);

                        var after_discount = total_price - data.discount_amount;
                        $("#price_total_final_info").html('$' + after_discount);
                    }
                }
            });
        });

        //in case the user want to delete the coupon
        $(document).on('click', '#delete_coupon', function() {
            var total_price = $('#services').find(':selected').data('price');
            $("#discount_amount_div").addClass('d-none');
            $('#coupon_input').val('');
            $("#search-result-input").html('');
            $("#price_total_final_info").html('$' + total_price);
            //set null to coupon id hidden input
            $("#coupon_id").val("");
        })
</script>

<!-- international telephone input -->
<script src="{{ URL::asset('plugins/intltelinput/intlTelInput.min.js') }}"></script>

<script>
    //to enable international telephone input (#int-miphone) is where we need to insert it
        const phoneInputField = document.querySelector("#int-miphone");
        const phoneInput = window.intlTelInput(phoneInputField, {
            //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
            preferredCountries: ["eg", "sa", "ae", "qa"],
            utilsScript: "{{ URL::asset('plugins/intltelinput/utils.js') }}",
        });
        const phoneInputField2 = document.querySelector("#int-miphone2");
        const phoneInput2 = window.intlTelInput(phoneInputField2, {
            //preferred countries https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
            preferredCountries: ["eg", "sa", "ae", "qa"],
            utilsScript: "{{ URL::asset('plugins/intltelinput/utils.js') }}",
        });
</script>
<script>
    function fetch_from_resource(branchID) {
        var url = "{{ route('sett.app_fetch_from_resource_ajax', ':id') }}";
            url = url.replace(':id', branchID);

            if (branchID) {
                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('select[name="from_recourse_id"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="from_recourse_id"]').append('<option value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            } else {
                $('select[name="from_recourse"]').empty();
            }

    }
    fetch_from_resource($('select[name="first_branch_id"]').val());
    //for from resource inputs
        $('select[name="first_branch_id"]').on('change', function(e) {
            e.preventDefault();

            var branchID = $(this).val();
            fetch_from_resource(branchID);

        });
</script>
@endsection
