<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Medicine extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'prescription_id',
        'medicines_cats',
        'medicine_type_id',
        'patient_id',
        'qty',
        'med_dose_id',
        'med_duration_id',
        'status',
    ];


    public function medicinescats()
    {
        return $this->belongsTo(Medicine_cat::class, 'medicines_cats', 'id');
    }

    public function medicine_type()
    {
        return $this->belongsTo(Medicine_type::class, 'medicine_type_id', 'id');
    }

    public function dose()
    {
        return $this->belongsTo(Med_dose::class, 'med_dose_id', 'id');
    }

    public function duration()
    {
        return $this->belongsTo(Med_duration::class, 'med_duration_id', 'id');
    }


    public function prescription()
    {
        return $this->belongsTo(Prescription::class, 'prescription_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }
}