<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Models\Patient\Medicine_cat as PatientMedicine_cat;
use App\Models\Patient\Pat_investigation;
use App\Models\Patient\Pat_investigation_item;
use App\Models\Patient\Patient;
use Illuminate\Http\Request;
use Mpdf\Mpdf;
use Mpdf\Tag\Input;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PDF;
use Image;
use DNS1D;
use DNS2D;

class Pat_investigationCont extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $medicine = Pat_investigation::all();
        return view('cats/medicinecat.index', compact('medicine'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/medicinecat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'patient_id' => 'required|exists:patients,id',
        ]);

        if ($request->input('radiology_investigation_status')) {
            $investigation = Pat_investigation::create([
                'cat' => 1,
                'type' => $request->input('pat_investigation_type'),
                'appointment_id' => $request->input('last_appointment_id_investigation'),
                'patient_id' => $request->input('patient_id'),
                'date' => $request->input('investigation_date'),
                'note' => $request->input('note_investigation'),
            ]);

            if ($request->input('colored_photo_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation->id,
                    'name' => "colored photo",
                    'value' => $request->input('colored_photo_ramad') . " (" . $request->input('colored_photo_type_ramad') . ")",
                ]);
            }

            if ($request->input('sonar_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation->id,
                    'name' => "sonar",
                    'value' => $request->input('sonar_ramad'),
                ]);
            }


            if ($request->input('ubm_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation->id,
                    'name' => "ubm",
                    'value' => $request->input('ubm_ramad'),
                ]);
            }


            if ($request->input('biometry_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation->id,
                    'name' => "biometry (IOL MASTER OPTICAL Biometry)",
                    'value' => $request->input('biometry_ramad'),
                ]);
            }

            if ($request->input('visual_field_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation->id,
                    'name' => "visual field",
                    'value' => $request->input('visual_field_ramad'),
                ]);
            }

            if ($request->input('ffa_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation->id,
                    'name' => "ffa",
                    'value' => $request->input('ffa_ramad'),
                ]);
            }

            if ($request->input('oct_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation->id,
                    'name' => "oct",
                    'value' => $request->input('oct_ramad') . " (" . $request->input('oct_type_ramad') . ")",
                ]);
            }

            if ($request->input('pentacam_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation->id,
                    'name' => "pentacam",
                    'value' => $request->input('pentacam_ramad') . " (" . $request->input('pentacam_type_ramad') . ")",
                ]);
            }

            if ($request->input('specular_microscopy_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation->id,
                    'name' => "specular microscopy",
                    'value' => $request->input('specular_microscopy_ramad'),
                ]);
            }
        }

        // --------- lab


        if ($request->input('lab_investigation_status')) {

            $investigation_lab = Pat_investigation::create([
                'cat' => 2,
                'type' => $request->input('pat_investigation_type'),
                'appointment_id' => $request->input('last_appointment_id_investigation'),
                'patient_id' => $request->input('patient_id'),
                'date' => $request->input('investigation_date'),
                'note' => $request->input('note_investigation'),
            ]);

            if ($request->input('cbc_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "complete blood count (CBC)",
                    'value' => $request->input('cbc_ramad'),
                ]);
            }

            if ($request->input('pt_pc_inr_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "prothrombin time and conc (PT-PC-INR)",
                    'value' => $request->input('pt_pc_inr_ramad'),
                ]);
            }

            if ($request->input('ptt_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "partial thromboplastin time (PTT)",
                    'value' => $request->input('ptt_ramad'),
                ]);
            }

            if ($request->input('hdlldl_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "cholesterol / HDL / LDL / triglycerides",
                    'value' => $request->input('hdlldl_ramad'),
                ]);
            }

            if ($request->input('blood_urea_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "blood urea",
                    'value' => $request->input('blood_urea_ramad'),
                ]);
            }

            if ($request->input('serum_creatinine_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "serum creatinine",
                    'value' => $request->input('serum_creatinine_ramad'),
                ]);
            }

            if ($request->input('sgpt_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "SGPT (ALT)",
                    'value' => $request->input('sgpt_ramad'),
                ]);
            }

            if ($request->input('sgot_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "SGOT (AST)",
                    'value' => $request->input('sgot_ramad'),
                ]);
            }

            if ($request->input('blood_glucose_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "blood glucose (Random)",
                    'value' => $request->input('blood_glucose_ramad'),
                ]);
            }

            if ($request->input('c_reactive_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "c-reactive protein (CRP) titre",
                    'value' => $request->input('c_reactive_ramad'),
                ]);
            }

            if ($request->input('hcv_antibody_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "HCV antibody 3rd generation",
                    'value' => $request->input('hcv_antibody_ramad'),
                ]);
            }

            if ($request->input('hbs_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "HBs antigen",
                    'value' => $request->input('hbs_ramad'),
                ]);
            }

            if ($request->input('aids_test_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "aids test (HIV 1And 2) 3rd generation",
                    'value' => $request->input('aids_test_ramad'),
                ]);
            }

            if ($request->input('hba1c_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "HBA1c",
                    'value' => $request->input('hba1c_ramad'),
                ]);
            }

            if ($request->input('urine_analysis_ramad')) {
                $items = Pat_investigation_item::create([
                    'pat_investigation_id' => $investigation_lab->id,
                    'name' => "urine analysis",
                    'value' => $request->input('urine_analysis_ramad'),
                ]);
            }
        }

        session()->flash('success', 'The investigation has been created successfully');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $medicine = Pat_investigation::find($id);
        return view('cats/medicinecat.edit', compact('medicine'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'price' => 'required|numeric',
        ]);

        $medicine = PatientMedicine_cat::find($id);
        $medicine->name = $request->input('name');
        $medicine->price = $request->input('price');
        $medicine->save();

        return redirect()->route('sett.medicinecat.index')
            ->with('success', 'Medicine has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id = $request->input('investigation_id_delete');

        Pat_investigation::find($id)->delete();

        session()->flash('success', 'The investigation has been deleted');
        return redirect()->back();
    }


    //print
    public function investigation_print($id, $cat, $pat_investigation_id = null)
    {

        if ($pat_investigation_id) {
            $patient = Patient::with(['investigation' => function ($q) use ($pat_investigation_id) {
                $q->where('id', $pat_investigation_id)
                    ->with('items');
            }])
                ->with(['investigation_lab' => function ($q) use ($pat_investigation_id) {
                    $q->where('id', $pat_investigation_id)
                        ->with('items');
                }])
                ->find($id);
        } else {
            $patient = Patient::with(['investigation' => function ($q) {
                $q->orderBy('id', 'desc')
                    ->with('items');
            }])
                ->with(['investigation_lab' => function ($q) {
                    $q->orderBy('id', 'desc')
                        ->with('items');
                }])
                ->find($id);
        }

        $qrcode = base64_encode(QrCode::color(36, 137, 127)->size(80)->style('round')->eye('circle')->generate($patient->code));

        // instantiate and use the dompdf class

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        $html = view('patient.print_investigation', compact('patient', 'cat', 'qrcode'))->render();

        $mpdf = new mPDF();

        if ($patient->new_id) {
            $new_id = explode('-', $patient->new_id);
            $new_id = $new_id[1];
        } else {
            $new_id = 0;
        }

        $mpdf->SetHTMLHeader('<div class="header">
        <div class="row">
        <div class="col-xs-9 m-0 ps-3">
            <img src="' . $logo . '">
        </div>
        <div class="col-xs-2 text-center m-0 ps-3">
        <img src="data:image/png;base64,' . DNS2D::getBarcodePNG($new_id, 'QRCODE') . '" height="80"
                    width="80" />
            <p class="mt-1 mb-0 text-s fw-bold2">' . $patient->code . '</p>
        </div>
        </div>
        </div>
        ', 'O');


        $mpdf->SetHTMLFooter('
        <div><img src="data:image/png;base64,' . DNS1D::getBarcodePNG($new_id, 'C39') . '" height="70"width="70" /><br /></div>
        <div class"text-center"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 17,
        ]);
        $mpdf->WriteHTML($html);
        $mpdf->output();

        // Output the generated PDF to Browser
        //return $mpdf->stream();

    }


    //print
    public function investigation_print_no_frame_a5($id, $cat, $pat_investigation_id = null)
    {

        if ($pat_investigation_id) {
            $patient = Patient::with(['investigation' => function ($q) use ($pat_investigation_id) {
                $q->where('id', $pat_investigation_id)
                    ->with('items');
            }])
                ->with(['investigation_lab' => function ($q) use ($pat_investigation_id) {
                    $q->where('id', $pat_investigation_id)
                        ->with('items');
                }])
                ->find($id);
        } else {
            $patient = Patient::with(['investigation' => function ($q) {
                $q->orderBy('id', 'desc')
                    ->with('items');
            }])
                ->with(['investigation_lab' => function ($q) {
                    $q->orderBy('id', 'desc')
                        ->with('items');
                }])
                ->find($id);
        }

        $qrcode = base64_encode(QrCode::color(36, 137, 127)->size(80)->style('round')->eye('circle')->generate($patient->code));

        // instantiate and use the dompdf class

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        if ($patient->new_id) {
            $new_id = explode('-', $patient->new_id);
            $new_id = $new_id[1];
        } else {
            $new_id = 0;
        }


        $html = view('patient.print_investigation', compact('patient', 'cat', 'new_id', 'qrcode'))->render();

        $mpdf = new mPDF([
            'mode' => 'utf-8',
            //'format' => 'A4-L' //'format' => [190, 236]
            'format' => 'A5',
        ]);


        $mpdf->SetHTMLFooter('
        <div><img src="data:image/png;base64,' . DNS1D::getBarcodePNG($new_id, 'C39') . '" height="70"width="70" /><br /></div>
        <div class"text-center" style="padding-bottom: 4rem;"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 38,
            'margin-bottom' => 40,
            'margin-left' => 8,
            'margin-right' => 8,
        ]);



        $mpdf->WriteHTML($html);
        $mpdf->output();

        // Output the generated PDF to Browser
        //return $mpdf->stream();

    }
}
