<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Branch\Inventory\Inventory_item;
use App\Models\Branch\Lab;
use App\Models\Branch\Operation;
use App\Models\Invoice\cost\Cost_cat;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\Invoice\Service_cost_material;
use App\Models\Invoice\Service_material;
use App\Models\Patient\Dental\Dent_main_cat;
use App\Models\Patient\Pulse_area_cat;
use App\Models\Patient\Service_inv_cat;
use App\Models\Patient\Service_item as PatientService_item;
use App\Models\Patient\Session_pat;
use App\Models\Patient\Specialty_cat;
use App\Rules\serviceDelete;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Service_item extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (Auth::user()->hasRole('Super-admin')) {
            $service = PatientService_item::withTrashed()->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
                ->with(['branch' => function ($q) {
                    $q->select('id', 'name');
                }])
                ->with(['service_inv_cat' => function ($q) {
                    $q->select('id', 'name');
                }])
                ->get();

            return view('cats/service_item.index', compact('service'));

        }
        else{
            $service = PatientService_item::with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
                ->with(['branch' => function ($q) {
                    $q->select('id', 'name');
                }])
                ->with(['service_inv_cat' => function ($q) {
                    $q->select('id', 'name');
                }])
                ->get();
            return view('cats/service_item.index', compact('service'));
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $specialty = Specialty_cat::all();
        $branch = Branch::all();
        $service = Service_inv_cat::whereIn('id', [1, 2, 3, 4, 5])->orderBy('id', 'ASC')->get();
        $dental_cats = Dent_main_cat::all();
        $costs = Cost_cat::all();

        return view('cats/service_item.create', compact('specialty', 'service', 'branch', 'dental_cats', 'costs'));
    }

    public function fetch_inventory($branch_id)
    {
        $inv = Inventory_item::select('id', 'name')->where('branch_id', $branch_id)->get();

        return $inv;
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'specialty_id' => 'required|exists:specialty_cats,id',
            'branch_id' => 'required',
            'service_inv_cat' => 'required|exists:service_inv_cats,id',
            'dent_main_cat_id' => 'sometimes|nullable|exists:dent_main_cats,id',
            'name' => 'required|unique:service_items,name',
            'price' => 'required|numeric',
            'package' => 'required|numeric',
            'package_items_number' => 'sometimes|required|numeric',
            'doctor_comm' => 'sometimes|nullable|numeric',
        ]);

        $service = PatientService_item::create([
            'specialty_id' => $request->input('specialty_id'),
            'branch_id' => $request->input('branch_id'),
            'service_inv_cat_id' => $request->input('service_inv_cat'),
            'dent_main_cat_id' => $request->input('dent_main_cat_id'),
            'name' => $request->input('name'),
            'price' => $request->input('price'),
            'pulses' => $request->input('pulses_amount'),
            'package' => $request->input('package'),
            'package_items_number' => $request->input('package_items_number'),
            'doctor_comm' => $request->input('doctor_comm'),
        ]);

        if ($request->input('cost_price')[0]) {
            foreach ($request->input('costs') as $key => $item) {
                if ($request->input('cost_price')[$key] !== null) {
                    $cost = Service_cost_material::create([
                        'type' => 1,
                        'service_item_id' => $service->id,
                        'cost_cat_id' => $item,
                        'price' => $request->input('cost_price')[$key],
                    ]);
                }
            }
        }

        if (!empty($request->input('qty')[0])) {
            foreach ($request->input('materials') as $key => $item) {
                $material = Service_cost_material::create([
                    'type' => 2,
                    'service_item_id' => $service->id,
                    'inventory_id' => $item,
                    'qty' => $request->input('qty')[$key],
                ]);
            }
        }

        return redirect()->route('sett.service_item.index')
            ->with('success', 'Service has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service = PatientService_item::with(['branch' => function ($q) {
            $q->select('id', 'name');
        }])
            ->with(['costs' => function ($q) {
                $q->select('id', 'service_item_id', 'cost_cat_id', 'price');
            }])
            ->with(['materials' => function ($q) {
                $q->select('id', 'service_item_id', 'inventory_id', 'qty');
            }])
            ->find($id);
        $specialty = Specialty_cat::all();
        $branch = Branch::all();
        $service_inv_cat = Service_inv_cat::all();
        $dental_cats = Dent_main_cat::all();

        $current_materials = $service->materials->pluck('inventory_id')->all();
        $materials = Inventory_item::select('id', 'name')->where('branch_id', $service->branch_id)->get();
        $costs = Cost_cat::all();

        return view('cats/service_item.edit', compact('service', 'specialty', 'branch', 'service_inv_cat', 'dental_cats', 'current_materials', 'materials', 'costs'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'price' => 'required|numeric',
            'doctor_comm' => 'nullable|numeric',
            'dent_main_cat_id' => 'sometimes|nullable|exists:dent_main_cats,id',
        ]);

        $service = PatientService_item::find($id);
        $service->branch_id = $request->input('branch_id');
        $service->dent_main_cat_id = $request->input('dent_main_cat_id');
        $service->name = $request->input('name');
        $service->price = $request->input('price');
        $service->pulses = $request->input('pulses_amount');
        $service->package_items_number = $request->input('package_items_number');
        $service->doctor_comm = $request->input('doctor_comm');
        $service->deactivate = $request->input('deactivate') !== null ? 1 : 0;

        $service->save();


        //delete costs if there is costs but the client decied to delete it
        if (count($service->costs) > 0) {
            if (!$request->input('costs')) {
                $service->costs()->delete();
            }
        }

        //insert costs
        if ($request->input('cost_price')[0]) {
            $service->costs()->delete();
            foreach ($request->input('costs') as $key => $item) {
                if ($request->input('cost_price')[$key] !== null) {
                    $cost = Service_cost_material::create([
                        'type' => 1,
                        'service_item_id' => $service->id,
                        'cost_cat_id' => $item,
                        'price' => $request->input('cost_price')[$key],
                    ]);
                }
            }
        }

        //delete metrials if there is metrials but the client decied to delete it
        if (count($service->materials) > 0) {
            if (!$request->input('materials')) {
                $service->materials()->delete();
            }
        }

        //insert metrials
        if ($request->input('materials')) {
            $service->materials()->delete();
            foreach ($request->input('materials') as $key => $item) {
                $material = Service_cost_material::create([
                    'type' => 2,
                    'service_item_id' => $service->id,
                    'inventory_id' => $item,
                    'qty' => $request->input('qty')[$key],
                ]);
            }
        }

        return redirect()->route('sett.service_item.index')
            ->with('success', 'Service has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        $service = PatientService_item::find($request->input('id_delete'));
        $service->delete();
        session()->flash('success', 'The item has been deleted');
        return redirect()->route('sett.service_item.index');
        /*$status = Invoice_item::where('categorizable_type', 'App\Models\Patient\Service_item')
            ->where('categorizable_id', $request->input('id_delete'))
            ->first();

        $status2 = Session_pat::where('services_cat_id', $request->input('id_delete'))
            ->first();

        $status3 = Appointment::where('services_cat_id', $request->input('id_delete'))
            ->first();

        $status4 = Operation::where('services_cat_id', $request->input('id_delete'))
            ->first();

        $status5 = Lab::where('services_cat_id', $request->input('id_delete'))
            ->first();

        if (empty($status) && empty($status2) && empty($status3) && empty($status4) && empty($status5)) {
            $service = PatientService_item::find($request->input('id_delete'));
            if (count($service->materials) > 0) {
                $service->materials()->delete();
            }
            $service->delete();

            session()->flash('success', 'The item has been deleted');
            return redirect()->route('sett.service_item.index');
        } else {
            session()->flash('error_delete', 'The item has been used before');
            return redirect()->route('sett.service_item.index');
        }*/
    }
    /**
     * Restore the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function restore(Request $request)
    {
        $service = PatientService_item::withTrashed()->find($request->input('id_restore'));
        $service->restore();
        session()->flash('success', 'The item has been restored');
        return redirect()->route('sett.service_item.index');
    }
    function fetchServices(Request $request)
    {

       return PatientService_item::select('id', 'name')->whereIn('service_inv_cat_id',$request->input('servicesCatID'))->get();

    }
}
