<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Patient\From_recourse;
use Illuminate\Http\Request;
use App\Models\Branch\Branch;

class Resource_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $resource = From_recourse::with('branch')->get();
        return view('cats/fromresourcecat.index', compact('resource'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $branches = Branch::all();
        return view('cats/fromresourcecat.create', compact('branches'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:treatment_cats,name',
            'branch_id' => ['sometimes', 'required', 'exists:branches,id'],
        ]);

        $resource = From_recourse::create([
            'name' => $request->input('name'),
            'branch_id' => $request->input('branch_id'),
        ]);

        return redirect()->route('sett.resourcecat.index')
            ->with('success', 'Treatment has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $resource = From_recourse::find($id);
        $branches = Branch::all();
        return view('cats/fromresourcecat.edit', compact('resource','branches'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'branch_id' => ['sometimes', 'required', 'exists:branches,id'],
        ]);

        $treatment = From_recourse::find($id);
        $treatment->name = $request->input('name');
        $treatment->branch_id = $request->input('branch_id');
        $treatment->save();

        return redirect()->route('sett.resourcecat.index')
            ->with('success', 'Treatment has updated successfully');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function fetchFrom_resourceAjax($id)
    {
        return From_recourse::where('branch_id', $id)->get();
    }
}
