<?php

namespace App\Http\Controllers\Branch\Cats;

use App\Http\Controllers\Controller;
use App\Models\Branch\Branch;
use App\Models\Branch\Unit;
use Illuminate\Http\Request;

class Unit_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        $units = Unit::get();
        return view('cats/unitcat.index', compact('units'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        $branches = Branch::all();
        return view('cats/unitcat.create', compact('branches'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        
        $this->validate($request, [
            'branch_id' => 'required|exists:branches,id',
            'name' => 'required',
        ]);
        
        $unit = Unit::create([  
            'branch_id' => $request->input('branch_id'),
            'name' => $request->input('name'),
        ]);
        
        return redirect()->route('sett.unitcat.index')
            ->with('success', 'Unit has created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $unit = Unit::find($id);
        $branch = Branch::select('id', 'name')->get();

        return view('cats/unitcat.edit', compact('unit','branch'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
        
        $this->validate($request, [
            'branch_id' => 'required|exists:branches,id',
            'name' => 'required',
        ]);

        $unit = Unit::find($id);
        $unit->branch_id = $request->input('branch_id');
        $unit->name = $request->input('name');
        $unit->save();

        return redirect()->route('sett.unitcat.index')
            ->with('success', 'Unit has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}